/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.model.ServersHandlerIO;
import org.apache.directory.studio.apacheds.model.ServersHandlerIOException;
import org.apache.directory.studio.apacheds.model.ServersHandlerListener;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServersHandler {
    private static ServersHandler instance;
    private List<Server> serversList = new ArrayList<Server>();
    private Map<String, Server> serversIdMap = new HashMap<String, Server>();
    private List<ServersHandlerListener> listeners = new ArrayList<ServersHandlerListener>();

    private ServersHandler() {
    }

    public static ServersHandler getDefault() {
        if (instance == null) {
            instance = new ServersHandler();
        }
        return instance;
    }

    public void addServer(Server server) {
        this.addServer(server, true);
        this.saveServersToStore();
    }

    private void addServer(Server server, boolean notifyListeners) {
        if (!this.serversList.contains(server)) {
            this.serversList.add(server);
            this.serversIdMap.put(server.getId(), server);
            if (notifyListeners) {
                for (ServersHandlerListener listener : this.listeners.toArray(new ServersHandlerListener[0])) {
                    listener.serverAdded(server);
                }
            }
        }
    }

    public void removeServer(Server server) {
        this.removeServer(server, true);
        this.saveServersToStore();
    }

    private void removeServer(Server server, boolean notifyListeners) {
        if (this.serversList.contains(server)) {
            this.serversList.remove(server);
            this.serversIdMap.remove(server.getId());
            if (notifyListeners) {
                for (ServersHandlerListener listener : this.listeners.toArray(new ServersHandlerListener[0])) {
                    listener.serverRemoved(server);
                }
            }
        }
    }

    public boolean containsServer(Server server) {
        return this.serversList.contains(server);
    }

    public void addListener(ServersHandlerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ServersHandlerListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void loadServersFromStore() {
        File store = this.getServersStorePath().toFile();
        File tempStore = this.getServersStoreTempPath().toFile();
        boolean loadFailed = false;
        String exceptionMessage = "";
        if (store.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(store);
                List<Server> servers = ServersHandlerIO.read(inputStream);
                for (Server server : servers) {
                    this.addServer(server, false);
                }
                return;
            }
            catch (FileNotFoundException e) {
                loadFailed = true;
                exceptionMessage = e.getMessage();
            }
            catch (ServersHandlerIOException e) {
                loadFailed = true;
                exceptionMessage = e.getMessage();
            }
            if (loadFailed) {
                if (tempStore.exists()) {
                    try {
                        FileInputStream inputStream = new FileInputStream(tempStore);
                        List<Server> servers = ServersHandlerIO.read(inputStream);
                        for (Server server : servers) {
                            this.addServer(server, false);
                        }
                        return;
                    }
                    catch (FileNotFoundException e) {
                        ApacheDsPluginUtils.reportError("An error occured when loading the servers.\n\n" + e.getMessage());
                    }
                    catch (ServersHandlerIOException e) {
                        ApacheDsPluginUtils.reportError("An error occured when loading the servers.\n\n" + e.getMessage());
                    }
                } else {
                    ApacheDsPluginUtils.reportError("An error occured when loading the servers.\n\n" + exceptionMessage);
                }
            }
        }
    }

    public void saveServersToStore() {
        FileOutputStream outputStream;
        File store = this.getServersStorePath().toFile();
        File tempStore = this.getServersStoreTempPath().toFile();
        boolean saveFailed = false;
        try {
            outputStream = new FileOutputStream(tempStore);
            ServersHandlerIO.write(this.serversList, outputStream);
            String content = FileUtils.readFileToString((File)tempStore, (String)"UTF-8");
            FileUtils.writeStringToFile((File)store, (String)content, (String)"UTF-8");
        }
        catch (FileNotFoundException e) {
            saveFailed = true;
        }
        catch (IOException e) {
            saveFailed = true;
        }
        if (saveFailed) {
            try {
                outputStream = new FileOutputStream(store);
                ServersHandlerIO.write(this.serversList, outputStream);
            }
            catch (FileNotFoundException e) {
                ApacheDsPluginUtils.reportError("An error occured when loading the servers.\n\n" + e.getMessage());
            }
            catch (IOException e) {
                ApacheDsPluginUtils.reportError("An error occured when loading the servers.\n\n" + e.getMessage());
            }
        }
    }

    private IPath getServersStorePath() {
        return ApacheDsPlugin.getDefault().getStateLocation().append("servers.xml");
    }

    private IPath getServersStoreTempPath() {
        return ApacheDsPlugin.getDefault().getStateLocation().append("servers-temp.xml");
    }

    public boolean isNameAvailable(String name) {
        for (Server server : this.serversList) {
            if (!server.getName().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    public List<Server> getServersList() {
        return this.serversList;
    }

    public Server getServerById(String id) {
        return this.serversIdMap.get(id);
    }
}

