/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerConfigurationV153;
import org.apache.directory.studio.apacheds.configuration.model.v154.ServerConfigurationV154;
import org.apache.directory.studio.apacheds.jobs.LaunchServerJob;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.views.ServersView;
import org.apache.mina.util.AvailablePortFinder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RunAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String ACTION_TEXT = "&Run";
    private ServersView view;

    public RunAction() {
        super(ACTION_TEXT);
        this.init();
    }

    public RunAction(ServersView view) {
        super(ACTION_TEXT);
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(ApacheDsPluginConstants.CMD_RUN);
        this.setActionDefinitionId(ApacheDsPluginConstants.CMD_RUN);
        this.setToolTipText("Run");
        this.setImageDescriptor(ApacheDsPlugin.getDefault().getImageDescriptor("resources/icons/run.gif"));
    }

    public void run() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty() && selection.size() == 1) {
            Server server = (Server)selection.getFirstElement();
            ServerConfiguration serverConfiguration = null;
            try {
                serverConfiguration = ApacheDsPluginUtils.getServerConfiguration(server);
            }
            catch (IOException e) {
                this.reportErrorReadingServerConfiguration(e.getMessage());
                return;
            }
            catch (ServerXmlIOException e) {
                this.reportErrorReadingServerConfiguration(e.getMessage());
                return;
            }
            if (serverConfiguration == null) {
                this.reportErrorReadingServerConfiguration(null);
                return;
            }
            String[] alreadyInUseProtocolPortsList = this.getAlreadyInUseProtocolPorts(serverConfiguration);
            if (alreadyInUseProtocolPortsList != null && alreadyInUseProtocolPortsList.length > 0) {
                String title = null;
                String message = null;
                if (alreadyInUseProtocolPortsList.length == 1) {
                    title = "Port already in use";
                    message = "The port of the protocol " + alreadyInUseProtocolPortsList[0] + " is already in use.";
                } else {
                    title = "Ports already in use";
                    message = "The ports of the following protocols are already in use:";
                    for (String alreadyInUseProtocolPort : alreadyInUseProtocolPortsList) {
                        message = message + ApacheDsPluginUtils.LINE_SEPARATOR + "    - " + alreadyInUseProtocolPort;
                    }
                }
                message = message + ApacheDsPluginUtils.LINE_SEPARATOR + ApacheDsPluginUtils.LINE_SEPARATOR + "Do you wish to continue?";
                MessageDialog dialog = new MessageDialog(this.view.getSite().getShell(), title, null, message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                if (dialog.open() == 1) {
                    return;
                }
            }
            ApacheDsPluginUtils.verifyLibrariesFolder(server);
            LaunchServerJob job = new LaunchServerJob(server, serverConfiguration);
            job.setLogsLevel(ApacheDsPluginUtils.getServerLogsLevel());
            job.setLogsPattern(ApacheDsPluginUtils.getServerLogsPattern());
            server.setLaunchJob(job);
            job.schedule();
        }
    }

    private void reportErrorReadingServerConfiguration(String errorMessage) {
        String message = null;
        message = errorMessage == null ? "Unable to read the server configuration." : "Unable to read the server configuration." + ApacheDsPluginUtils.LINE_SEPARATOR + ApacheDsPluginUtils.LINE_SEPARATOR + "The following error occurred: " + errorMessage;
        MessageDialog dialog = new MessageDialog(this.view.getSite().getShell(), "Unable to read the server configuration", null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    private String[] getAlreadyInUseProtocolPorts(ServerConfiguration serverConfiguration) {
        if (serverConfiguration instanceof ServerConfigurationV154) {
            return this.getAlreadyInUseProtocolPortsVersion154((ServerConfigurationV154)serverConfiguration);
        }
        if (serverConfiguration instanceof ServerConfigurationV153) {
            return this.getAlreadyInUseProtocolPortsVersion153((ServerConfigurationV153)serverConfiguration);
        }
        return new String[0];
    }

    private String[] getAlreadyInUseProtocolPortsVersion153(ServerConfigurationV153 serverConfiguration) {
        ArrayList<String> alreadyInUseProtocolPortsList = new ArrayList<String>();
        if (serverConfiguration.isEnableLdap() && !AvailablePortFinder.available((int)serverConfiguration.getLdapPort())) {
            alreadyInUseProtocolPortsList.add("LDAP (port " + serverConfiguration.getLdapPort() + ")");
        }
        if (serverConfiguration.isEnableLdaps() && !AvailablePortFinder.available((int)serverConfiguration.getLdapsPort())) {
            alreadyInUseProtocolPortsList.add("LDAPS (port " + serverConfiguration.getLdapsPort() + ")");
        }
        if (serverConfiguration.isEnableKerberos() && !AvailablePortFinder.available((int)serverConfiguration.getKerberosPort())) {
            alreadyInUseProtocolPortsList.add("Kerberos (port " + serverConfiguration.getKerberosPort() + ")");
        }
        if (serverConfiguration.isEnableDns() && !AvailablePortFinder.available((int)serverConfiguration.getDnsPort())) {
            alreadyInUseProtocolPortsList.add("DNS (port " + serverConfiguration.getDnsPort() + ")");
        }
        if (serverConfiguration.isEnableNtp() && !AvailablePortFinder.available((int)serverConfiguration.getNtpPort())) {
            alreadyInUseProtocolPortsList.add("NTP (port " + serverConfiguration.getNtpPort() + ")");
        }
        if (serverConfiguration.isEnableChangePassword() && !AvailablePortFinder.available((int)serverConfiguration.getChangePasswordPort())) {
            alreadyInUseProtocolPortsList.add("ChangePassword (port " + serverConfiguration.getChangePasswordPort() + ")");
        }
        return alreadyInUseProtocolPortsList.toArray(new String[0]);
    }

    private String[] getAlreadyInUseProtocolPortsVersion154(ServerConfigurationV154 serverConfiguration) {
        ArrayList<String> alreadyInUseProtocolPortsList = new ArrayList<String>();
        if (serverConfiguration.isEnableLdap() && !AvailablePortFinder.available((int)serverConfiguration.getLdapPort())) {
            alreadyInUseProtocolPortsList.add("LDAP (port " + serverConfiguration.getLdapPort() + ")");
        }
        if (serverConfiguration.isEnableLdaps() && !AvailablePortFinder.available((int)serverConfiguration.getLdapsPort())) {
            alreadyInUseProtocolPortsList.add("LDAPS (port " + serverConfiguration.getLdapsPort() + ")");
        }
        if (serverConfiguration.isEnableKerberos() && !AvailablePortFinder.available((int)serverConfiguration.getKerberosPort())) {
            alreadyInUseProtocolPortsList.add("Kerberos (port " + serverConfiguration.getKerberosPort() + ")");
        }
        if (serverConfiguration.isEnableDns() && !AvailablePortFinder.available((int)serverConfiguration.getDnsPort())) {
            alreadyInUseProtocolPortsList.add("DNS (port " + serverConfiguration.getDnsPort() + ")");
        }
        if (serverConfiguration.isEnableNtp() && !AvailablePortFinder.available((int)serverConfiguration.getNtpPort())) {
            alreadyInUseProtocolPortsList.add("NTP (port " + serverConfiguration.getNtpPort() + ")");
        }
        if (serverConfiguration.isEnableChangePassword() && !AvailablePortFinder.available((int)serverConfiguration.getChangePasswordPort())) {
            alreadyInUseProtocolPortsList.add("ChangePassword (port " + serverConfiguration.getChangePasswordPort() + ")");
        }
        return alreadyInUseProtocolPortsList.toArray(new String[0]);
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

