/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.actions;

import org.apache.directory.studio.apacheds.ApacheDsPluginConstants;
import org.apache.directory.studio.apacheds.model.Server;
import org.apache.directory.studio.apacheds.views.ServersView;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PropertiesAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String ACTION_TEXT = "&Properties";
    private ServersView view;

    public PropertiesAction() {
        super(ACTION_TEXT);
        this.init();
    }

    public PropertiesAction(ServersView view) {
        super(ACTION_TEXT);
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(ApacheDsPluginConstants.CMD_PROPERTIES);
        this.setActionDefinitionId(ApacheDsPluginConstants.CMD_PROPERTIES);
        this.setToolTipText("Properties");
    }

    public void run() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty()) {
            Server server = (Server)selection.getFirstElement();
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.view.getViewSite().getShell(), (IAdaptable)server, (String)ApacheDsPluginConstants.PROP_SERVER_PROPERTY_PAGE, null, null);
            dialog.getShell().setText("Properties for '" + PropertiesAction.shorten(server.getName(), 30) + "'");
            dialog.open();
        }
    }

    public static String shorten(String label, int maxLength) {
        if (label == null) {
            return null;
        }
        if (maxLength < 3) {
            return "...";
        }
        if (label.length() > maxLength) {
            label = label.substring(0, maxLength / 2) + "..." + label.substring(label.length() - maxLength / 2, label.length());
        }
        StringBuffer sb = new StringBuffer(maxLength + 3);
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (Character.isISOControl(c)) {
                sb.append('.');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

