/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds;

import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.ApacheDsPluginUtils;
import org.apache.directory.studio.apacheds.ConsolesHandler;
import org.apache.directory.studio.apacheds.LogMessageConsole;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class StudioConsoleAppender
extends AppenderSkeleton {
    private String serverId;

    public StudioConsoleAppender() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                StudioConsoleAppender.this.setLayout((Layout)new PatternLayout(ApacheDsPluginUtils.getServerLogsPattern()));
            }
        });
        ApacheDsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("prefs.serverLogs.pattern".equalsIgnoreCase(event.getProperty())) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            StudioConsoleAppender.this.setLayout((Layout)new PatternLayout(ApacheDsPluginUtils.getServerLogsPattern()));
                        }
                    });
                }
            }
        });
    }

    protected void append(LoggingEvent event) {
        LogMessageConsole console = ConsolesHandler.getDefault().getLogMessageConsole(this.serverId);
        if (console != null) {
            String message = this.layout.format(event);
            Level level = event.getLevel();
            if (level == Level.INFO) {
                console.getInfoConsoleMessageStream().print(message);
            } else if (level == Level.DEBUG) {
                console.getDebugConsoleMessageStream().print(message);
            } else if (level == Level.WARN) {
                console.getWarnConsoleMessageStream().print(message);
            } else if (level == Level.ERROR) {
                console.getErrorConsoleMessageStream().print(message);
            } else if (level == Level.FATAL) {
                console.getFatalConsoleMessageStream().print(message);
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }
}

