/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.directory.studio.apacheds.ApacheDsPlugin;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerXmlIOV153;
import org.apache.directory.studio.apacheds.configuration.model.v154.ServerXmlIOV154;
import org.apache.directory.studio.apacheds.model.Server;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.osgi.framework.Bundle;

public class ApacheDsPluginUtils {
    private static final String RESOURCES = "resources";
    private static final String LIBS = "libs";
    private static final String SERVERS = "servers";
    private static final String LIBRARIES_FOLDER_NAME = "libs";
    private static final String APACHEDS = "apacheds";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void verifyLibrariesFolder(Server server) {
        IPath apacheDsFolderPath;
        File apacheDsFolder;
        IPath stateLocationPath = ApacheDsPlugin.getDefault().getStateLocation();
        IPath librariesFolderPath = stateLocationPath.append("libs");
        File librariesFolder = new File(librariesFolderPath.toOSString());
        if (!librariesFolder.exists()) {
            librariesFolder.mkdir();
        }
        if (!(apacheDsFolder = new File((apacheDsFolderPath = librariesFolderPath.append("apacheds-" + (Object)((Object)server.getVersion()))).toOSString())).exists()) {
            apacheDsFolder.mkdir();
        }
        for (String apachedsLibraryFilename : ApacheDsPluginUtils.getApacheDsLibraries(server)) {
            IPath apachedsLibraryPath = apacheDsFolderPath.append(apachedsLibraryFilename);
            File apachedsLibrary = new File(apachedsLibraryPath.toOSString());
            if (apachedsLibrary.exists()) continue;
            try {
                ApacheDsPluginUtils.copyLibrary(apachedsLibraryFilename, apachedsLibrary, server);
            }
            catch (IOException e) {
                ApacheDsPluginUtils.reportError("An error occurred when copying the library '" + apachedsLibraryFilename + "' to the location '" + apachedsLibrary.getAbsolutePath() + "'.\n\n" + e.getMessage());
            }
        }
    }

    public static String[] getApacheDsLibraries(Server server) {
        if (server != null) {
            switch (server.getVersion()) {
                case VERSION_1_5_4: {
                    return new String[]{"antlr-2.7.7.jar", "xbean-spring-3.3.jar", "apacheds-bootstrap-extract-1.5.4.jar", "apacheds-bootstrap-partition-1.5.4.jar", "apacheds-core-1.5.4.jar", "apacheds-core-avl-1.5.4.jar", "apacheds-core-constants-1.5.4.jar", "apacheds-core-cursor-1.5.4.jar", "apacheds-core-entry-1.5.4.jar", "apacheds-core-shared-1.5.4.jar", "apacheds-jdbm-1.5.4.jar", "apacheds-jdbm-store-1.5.4.jar", "apacheds-kerberos-shared-1.5.4.jar", "apacheds-launcher-1.2.0.jar", "apacheds-protocol-changepw-1.5.4.jar", "apacheds-protocol-dns-1.5.4.jar", "apacheds-protocol-kerberos-1.5.4.jar", "apacheds-protocol-ldap-1.5.4.jar", "apacheds-protocol-ntp-1.5.4.jar", "apacheds-protocol-shared-1.5.4.jar", "apacheds-schema-bootstrap-1.5.4.jar", "apacheds-schema-extras-1.5.4.jar", "apacheds-schema-registries-1.5.4.jar", "apacheds-server-jndi-1.5.4.jar", "apacheds-server-xml-1.5.4.jar", "apacheds-utils-1.5.4.jar", "apacheds-xbean-spring-1.5.4.jar", "apacheds-xdbm-base-1.5.4.jar", "apacheds-xdbm-search-1.5.4.jar", "apacheds-xdbm-tools-1.5.4.jar", "commons-cli-1.1.jar", "commons-collections-3.2.jar", "commons-daemon-1.0.1.jar", "commons-lang-2.3.jar", "daemon-bootstrappers-1.1.4.jar", "jcl104-over-slf4j-1.4.3.jar", "log4j-1.2.14.jar", "mina-core-1.1.6.jar", "mina-filter-ssl-1.1.6.jar", "shared-asn1-0.9.12.jar", "shared-asn1-codec-0.9.12.jar", "shared-bouncycastle-reduced-0.9.12.jar", "shared-ldap-0.9.12.jar", "shared-ldap-constants-0.9.12.jar", "slf4j-api-1.4.3.jar", "slf4j-log4j12-1.4.3.jar", "spring-beans-2.0.6.jar", "spring-context-2.0.6.jar", "spring-core-2.0.6.jar"};
                }
                case VERSION_1_5_3: {
                    return new String[]{"antlr-2.7.7.jar", "apacheds-bootstrap-extract-1.5.3.jar", "apacheds-bootstrap-partition-1.5.3.jar", "apacheds-btree-base-1.5.3.jar", "apacheds-core-1.5.3.jar", "apacheds-core-constants-1.5.3.jar", "apacheds-core-entry-1.5.3.jar", "apacheds-core-shared-1.5.3.jar", "apacheds-jdbm-1.5.3.jar", "apacheds-jdbm-store-1.5.3.jar", "apacheds-kerberos-shared-1.5.3.jar", "apacheds-launcher-1.2.0.jar", "apacheds-protocol-changepw-1.5.3.jar", "apacheds-protocol-dns-1.5.3.jar", "apacheds-protocol-kerberos-1.5.3.jar", "apacheds-protocol-ldap-1.5.3.jar", "apacheds-protocol-ntp-1.5.3.jar", "apacheds-protocol-shared-1.5.3.jar", "apacheds-schema-bootstrap-1.5.3.jar", "apacheds-schema-extras-1.5.3.jar", "apacheds-schema-registries-1.5.3.jar", "apacheds-server-jndi-1.5.3.jar", "apacheds-server-xml-1.5.3.jar", "apacheds-utils-1.5.3.jar", "apacheds-xbean-spring-1.5.3.jar", "commons-cli-1.1.jar", "commons-collections-3.2.jar", "commons-daemon-1.0.1.jar", "commons-lang-2.3.jar", "daemon-bootstrappers-1.1.3.jar", "jcl104-over-slf4j-1.4.3.jar", "log4j-1.2.14.jar", "mina-core-1.1.6.jar", "mina-filter-ssl-1.1.6.jar", "shared-asn1-0.9.11.jar", "shared-asn1-codec-0.9.11.jar", "shared-bouncycastle-reduced-0.9.11.jar", "shared-ldap-0.9.11.jar", "shared-ldap-constants-0.9.11.jar", "slf4j-api-1.4.3.jar", "slf4j-log4j12-1.4.3.jar", "spring-beans-2.0.6.jar", "spring-context-2.0.6.jar", "spring-core-2.0.6.jar", "xbean-spring-3.3.jar"};
                }
            }
        }
        return new String[0];
    }

    private static void copyLibrary(String library, File destination, Server server) throws IOException {
        URL libraryUrl = FileLocator.find((Bundle)ApacheDsPlugin.getDefault().getBundle(), (IPath)new Path("resources/libs/apacheds-" + server.getVersion().toString() + '/' + library), null);
        InputStream libraryInputStream = libraryUrl.openStream();
        FileOutputStream libraryOutputStream = new FileOutputStream(destination);
        ApacheDsPluginUtils.copyFile(libraryInputStream, libraryOutputStream);
        libraryInputStream.close();
        libraryOutputStream.close();
    }

    private static void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, i);
        }
    }

    public static IPath getApacheDsLibrariesFolder(Server server) {
        return ApacheDsPlugin.getDefault().getStateLocation().append("libs").append("apacheds-" + (Object)((Object)server.getVersion()));
    }

    public static IPath getApacheDsServersFolder() {
        return ApacheDsPlugin.getDefault().getStateLocation().append(SERVERS);
    }

    public static void createNewServerFolder(String id) {
        ApacheDsPluginUtils.checkApacheDsServersFolder();
        IPath serverFolderPath = ApacheDsPluginUtils.getApacheDsServersFolder().append(id);
        File serverFolder = new File(serverFolderPath.toOSString());
        serverFolder.mkdir();
        File confFolder = new File(serverFolder, "conf");
        confFolder.mkdir();
        File serverSocketFolder = new File(serverFolder, "serverSocket");
        serverSocketFolder.mkdir();
        new File(serverFolder, "ldif").mkdir();
        new File(serverFolder, "log").mkdir();
        new File(serverFolder, "partitions").mkdir();
        try {
            File log4jPropertiesFile = new File(confFolder, "log4j.properties");
            ApacheDsPluginUtils.createServersLog4jPropertiesFile(new FileOutputStream(log4jPropertiesFile), 1024, ApacheDsPluginUtils.getServerLogsLevel(), ApacheDsPluginUtils.getServerLogsPattern());
            File serverXmlFile = new File(confFolder, "server.xml");
            ApacheDsPluginUtils.copyConfigurationFile("server-1.5.4.xml", serverXmlFile);
            File log4jPropertiesServerSocketFile = new File(serverSocketFolder, "log4j.properties");
            ApacheDsPluginUtils.createServerSocketLog4jPropertiesFile(new FileOutputStream(log4jPropertiesServerSocketFile), id);
        }
        catch (IOException e) {
            ApacheDsPluginUtils.reportError("An error occurred when copying the default configuration files to the server's folder '" + serverFolder.getAbsolutePath() + "'.\n\n" + e.getMessage());
        }
    }

    public static void createServersLog4jPropertiesFile(OutputStream os, int port, String logsLevel, String logsPattern) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("#############################################################################").append("\n");
        sb.append("#    Licensed to the Apache Software Foundation (ASF) under one or more").append("\n");
        sb.append("#    contributor license agreements.  See the NOTICE file distributed with").append("\n");
        sb.append("#    this work for additional information regarding copyright ownership.").append("\n");
        sb.append("#    The ASF licenses this file to You under the Apache License, Version 2.0").append("\n");
        sb.append("#    (the \"License\"); you may not use this file except in compliance with").append("\n");
        sb.append("#    the License.  You may obtain a copy of the License at").append("\n");
        sb.append("#").append("\n");
        sb.append("#       http://www.apache.org/licenses/LICENSE-2.0").append("\n");
        sb.append("#").append("\n");
        sb.append("#    Unless required by applicable law or agreed to in writing, software").append("\n");
        sb.append("#    distributed under the License is distributed on an \"AS IS\" BASIS,").append("\n");
        sb.append("#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.").append("\n");
        sb.append("#    See the License for the specific language governing permissions and").append("\n");
        sb.append("#    limitations under the License.").append("\n");
        sb.append("#############################################################################").append("\n");
        sb.append("log4j.rootCategory=" + logsLevel + ", socketAppender, rollingFileAppender").append("\n");
        sb.append("").append("\n");
        sb.append("# The Socket Appender (used to send the logs to Apache Directory Studio)").append("\n");
        sb.append("log4j.appender.socketAppender=org.apache.log4j.net.SocketAppender").append("\n");
        sb.append("log4j.appender.socketAppender.RemoteHost=localhost").append("\n");
        sb.append("log4j.appender.socketAppender.Port=").append(port).append("\n");
        sb.append("").append("\n");
        sb.append("# The Rolling File Appender").append("\n");
        sb.append("log4j.appender.rollingFileAppender=org.apache.log4j.RollingFileAppender").append("\n");
        sb.append("log4j.appender.rollingFileAppender.File=${apacheds.log.dir}/apacheds-rolling.log").append("\n");
        sb.append("log4j.appender.rollingFileAppender.MaxFileSize=1024KB").append("\n");
        sb.append("log4j.appender.rollingFileAppender.MaxBackupIndex=5").append("\n");
        sb.append("log4j.appender.rollingFileAppender.layout=org.apache.log4j.PatternLayout").append("\n");
        sb.append("log4j.appender.rollingFileAppender.layout.ConversionPattern=[%d{HH:mm:ss}] %p [%c] - %m%n").append("\n");
        sb.append("").append("\n");
        sb.append("# with these we'll not get innundated when switching to DEBUG").append("\n");
        sb.append("log4j.logger.org.apache.directory.shared.ldap.name=WARN").append("\n");
        sb.append("log4j.logger.org.springframework=WARN").append("\n");
        sb.append("log4j.logger.org.apache.directory.shared.codec=WARN").append("\n");
        sb.append("log4j.logger.org.apache.directory.shared.asn1=WARN").append("\n");
        os.write(sb.toString().getBytes());
    }

    private static void createServerSocketLog4jPropertiesFile(OutputStream os, String id) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("#############################################################################").append("\n");
        sb.append("#    Licensed to the Apache Software Foundation (ASF) under one or more").append("\n");
        sb.append("#    contributor license agreements.  See the NOTICE file distributed with").append("\n");
        sb.append("#    this work for additional information regarding copyright ownership.").append("\n");
        sb.append("#    The ASF licenses this file to You under the Apache License, Version 2.0").append("\n");
        sb.append("#    (the \"License\"); you may not use this file except in compliance with").append("\n");
        sb.append("#    the License.  You may obtain a copy of the License at").append("\n");
        sb.append("#").append("\n");
        sb.append("#       http://www.apache.org/licenses/LICENSE-2.0").append("\n");
        sb.append("#").append("\n");
        sb.append("#    Unless required by applicable law or agreed to in writing, software").append("\n");
        sb.append("#    distributed under the License is distributed on an \"AS IS\" BASIS,").append("\n");
        sb.append("#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.").append("\n");
        sb.append("#    See the License for the specific language governing permissions and").append("\n");
        sb.append("#    limitations under the License.").append("\n");
        sb.append("#############################################################################").append("\n");
        sb.append("log4j.rootCategory=ALL, studioConsoleAppender").append("\n");
        sb.append("").append("\n");
        sb.append("# Studio Console Appender (identified with the server id)").append("\n");
        sb.append("log4j.appender.studioConsoleAppender=org.apache.directory.studio.apacheds.StudioConsoleAppender").append("\n");
        sb.append("log4j.appender.studioConsoleAppender.ServerId=").append(id).append("\n");
        sb.append("log4j.appender.studioConsoleAppender.layout=org.apache.log4j.PatternLayout").append("\n");
        sb.append("").append("\n");
        sb.append("# Hiding logs from log4j").append("\n");
        sb.append("log4j.logger.org.apache.log4j.net.SocketServer=OFF").append("\n");
        sb.append("log4j.logger.org.apache.log4j.net.SocketNode=OFF").append("\n");
        os.write(sb.toString().getBytes());
    }

    private static void copyConfigurationFile(String inputFilename, File ouputFile) throws IOException {
        URL inputFilenameUrl = FileLocator.find((Bundle)ApacheDsPlugin.getDefault().getBundle(), (IPath)new Path("resources/conf/" + inputFilename), null);
        InputStream inputStream = inputFilenameUrl.openStream();
        FileOutputStream outputStream = new FileOutputStream(ouputFile);
        ApacheDsPluginUtils.copyFile(inputStream, outputStream);
        inputStream.close();
        ((OutputStream)outputStream).close();
    }

    private static void checkApacheDsServersFolder() {
        File apacheDsserversFolder = new File(ApacheDsPluginUtils.getApacheDsServersFolder().toOSString());
        if (!apacheDsserversFolder.exists()) {
            apacheDsserversFolder.mkdir();
        }
    }

    public static String getServerLogsLevel() {
        String level = ApacheDsPlugin.getDefault().getPreferenceStore().getString("prefs.serverLogs.level");
        if ("debug".equalsIgnoreCase(level)) {
            return "DEBUG";
        }
        if ("info".equalsIgnoreCase(level)) {
            return "INFO";
        }
        if ("warning".equalsIgnoreCase(level)) {
            return "WARN";
        }
        if ("error".equalsIgnoreCase(level)) {
            return "ERROR";
        }
        if ("fatal".equalsIgnoreCase(level)) {
            return "FATAL";
        }
        return "";
    }

    public static String getServerLogsPattern() {
        return ApacheDsPlugin.getDefault().getPreferenceStore().getString("prefs.serverLogs.pattern");
    }

    public static void reportError(String message) {
        MessageDialog dialog = new MessageDialog(ApacheDsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), "Error!", null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static ServerConfiguration getServerConfiguration(Server server) throws ServerXmlIOException, IOException {
        FileInputStream fis = new FileInputStream(new File(ApacheDsPluginUtils.getApacheDsServersFolder().append(server.getId()).append("conf").append("server.xml").toOSString()));
        switch (server.getVersion()) {
            case VERSION_1_5_4: {
                ServerXmlIOV154 serverXmlIOV154 = new ServerXmlIOV154();
                return serverXmlIOV154.parse((InputStream)fis);
            }
            case VERSION_1_5_3: {
                ServerXmlIOV153 serverXmlIOV153 = new ServerXmlIOV153();
                return serverXmlIOV153.parse((InputStream)fis);
            }
        }
        return null;
    }
}

