/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtils {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss'Z'");

    private DateUtils() {
    }

    public static Date getDate(String zuluTime) {
        Calendar cal = Calendar.getInstance(UTC_TIME_ZONE);
        cal.set(1, DateUtils.getYear(zuluTime));
        cal.set(2, DateUtils.getMonth(zuluTime) - 1);
        cal.set(5, DateUtils.getDay(zuluTime));
        cal.set(11, DateUtils.getHour(zuluTime));
        cal.set(12, DateUtils.getMinutes(zuluTime));
        cal.set(13, DateUtils.getSeconds(zuluTime));
        return cal.getTime();
    }

    public static int getYear(String zuluTime) {
        return Integer.parseInt(zuluTime.substring(0, 4));
    }

    public static int getMonth(String zuluTime) {
        return Integer.parseInt(zuluTime.substring(4, 6));
    }

    public static int getDay(String zuluTime) {
        return Integer.parseInt(zuluTime.substring(6, 8));
    }

    public static int getHour(String zuluTime) {
        return Integer.parseInt(zuluTime.substring(8, 10));
    }

    public static int getMinutes(String zuluTime) {
        return Integer.parseInt(zuluTime.substring(10, 12));
    }

    public static int getSeconds(String zuluTime) {
        return Integer.parseInt(zuluTime.substring(12, 14));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGeneralizedTime() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(date);
        }
    }

    public static String getGeneralizedTime(long time) {
        return DateUtils.getGeneralizedTime(new Date(time));
    }

    static {
        DATE_FORMAT.setTimeZone(UTC_TIME_ZONE);
    }
}

