/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.registries;

import java.util.Iterator;
import java.util.Map;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.model.schema.registries.AttributeTypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableAttributeTypeRegistry
implements AttributeTypeRegistry {
    AttributeTypeRegistry immutableAttributeTypeRegistry;

    public ImmutableAttributeTypeRegistry(AttributeTypeRegistry attributeTypeRegistry) {
        this.immutableAttributeTypeRegistry = attributeTypeRegistry;
    }

    @Override
    public Map<String, OidNormalizer> getNormalizerMapping() {
        return this.immutableAttributeTypeRegistry.getNormalizerMapping();
    }

    @Override
    public boolean hasDescendants(String ancestorId) throws LdapException {
        return this.immutableAttributeTypeRegistry.hasDescendants(ancestorId);
    }

    @Override
    public boolean hasDescendants(AttributeType ancestor) throws LdapException {
        return this.immutableAttributeTypeRegistry.hasDescendants(ancestor);
    }

    @Override
    public Iterator<AttributeType> descendants(String ancestorId) throws LdapException {
        return this.immutableAttributeTypeRegistry.descendants(ancestorId);
    }

    @Override
    public Iterator<AttributeType> descendants(AttributeType ancestor) throws LdapException {
        return this.immutableAttributeTypeRegistry.descendants(ancestor);
    }

    @Override
    public void register(AttributeType attributeType) throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, I18n.err(I18n.ERR_04275, new Object[0]));
    }

    @Override
    public void registerDescendants(AttributeType attributeType, AttributeType ancestor) throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, I18n.err(I18n.ERR_04275, new Object[0]));
    }

    @Override
    public void unregisterDescendants(AttributeType attributeType, AttributeType ancestor) throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, I18n.err(I18n.ERR_04275, new Object[0]));
    }

    @Override
    public AttributeType unregister(String numericOid) throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, "Cannot modify the AttributeTypeRegistry copy");
    }

    @Override
    public void addMappingFor(AttributeType attributeType) throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, I18n.err(I18n.ERR_04275, new Object[0]));
    }

    @Override
    public void removeMappingFor(AttributeType attributeType) throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, I18n.err(I18n.ERR_04275, new Object[0]));
    }

    @Override
    public AttributeType lookup(String oid) throws LdapException {
        return (AttributeType)this.immutableAttributeTypeRegistry.lookup(oid);
    }

    public String toString() {
        return this.immutableAttributeTypeRegistry.toString();
    }

    @Override
    public AttributeTypeRegistry copy() {
        return this.immutableAttributeTypeRegistry.copy();
    }

    @Override
    public int size() {
        return this.immutableAttributeTypeRegistry.size();
    }

    @Override
    public Iterator<AttributeType> iterator() {
        return this.immutableAttributeTypeRegistry.iterator();
    }

    @Override
    public Iterator<String> oidsIterator() {
        return this.immutableAttributeTypeRegistry.oidsIterator();
    }

    @Override
    public boolean contains(String oid) {
        return this.immutableAttributeTypeRegistry.contains(oid);
    }

    @Override
    public String getOidByName(String name) throws LdapException {
        try {
            return this.immutableAttributeTypeRegistry.getOidByName(name);
        }
        catch (LdapException le) {
            throw new LdapNoSuchAttributeException(le.getMessage());
        }
    }

    @Override
    public String getSchemaName(String oid) throws LdapException {
        return this.immutableAttributeTypeRegistry.getSchemaName(oid);
    }

    @Override
    public SchemaObjectType getType() {
        return this.immutableAttributeTypeRegistry.getType();
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
    }

    @Override
    public void unregisterSchemaElements(String schemaName) throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, I18n.err(I18n.ERR_04275, new Object[0]));
    }

    @Override
    public AttributeType get(String oid) {
        return (AttributeType)this.immutableAttributeTypeRegistry.get(oid);
    }

    @Override
    public void clear() throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, I18n.err(I18n.ERR_04275, new Object[0]));
    }

    @Override
    public AttributeType unregister(AttributeType schemaObject) throws LdapException {
        throw new LdapUnwillingToPerformException(ResultCodeEnum.NO_SUCH_OPERATION, I18n.err(I18n.ERR_04275, new Object[0]));
    }
}

