/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.comparators;

import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(WordComparator.class);

    public WordComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String value, String assertion) {
        LOG.debug("comparing String objects '{}' with '{}'", (Object)value, (Object)assertion);
        if (value == assertion) {
            return 0;
        }
        if (value == null || assertion == null) {
            return assertion == null ? 1 : -1;
        }
        String trimmedAssertion = Strings.trim(assertion);
        int pos = value.indexOf(trimmedAssertion);
        if (pos != -1) {
            int assertionLength = trimmedAssertion.length();
            if (assertionLength == value.length()) {
                return 0;
            }
            if (pos == 0) {
                char after = value.charAt(assertionLength);
                if (!Character.isLetterOrDigit(after)) {
                    return 0;
                }
                return -1;
            }
            if (pos + assertionLength == value.length()) {
                char before = value.charAt(value.length() - assertionLength - 1);
                if (!Character.isLetterOrDigit(before)) {
                    return 0;
                }
                return -1;
            }
            char before = value.charAt(value.length() - assertionLength);
            char after = value.charAt(assertionLength);
            if (Character.isLetterOrDigit(after)) {
                return -1;
            }
            if (!Character.isLetterOrDigit(before)) {
                return -1;
            }
            return 0;
        }
        return -1;
    }
}

