/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.comparators;

import java.io.IOException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.PrepareString;
import org.apache.directory.shared.util.GeneralizedTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizedTimeComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(GeneralizedTimeComparator.class);

    public GeneralizedTimeComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String backendValue, String assertValue) {
        GeneralizedTime assertTime;
        GeneralizedTime backendTime;
        LOG.debug("comparing generalizedTimeOrdering objects '{}' with '{}'", (Object)backendValue, (Object)assertValue);
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        try {
            String prepared = PrepareString.normalize(backendValue, PrepareString.StringType.DIRECTORY_STRING);
            backendTime = new GeneralizedTime(prepared);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04224, backendValue));
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04224, backendValue));
        }
        try {
            String prepared = PrepareString.normalize(assertValue, PrepareString.StringType.DIRECTORY_STRING);
            assertTime = new GeneralizedTime(prepared);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04224, assertValue));
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04224, assertValue));
        }
        return backendTime.compareTo(assertTime);
    }
}

