/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.comparators;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnComparator
extends LdapComparator<Object> {
    private static final long serialVersionUID = 2L;
    private SchemaManager schemaManager;

    public DnComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(Object obj0, Object obj1) {
        Dn dn0 = null;
        Dn dn1 = null;
        try {
            dn0 = this.getDn(obj0);
            dn1 = this.getDn(obj1);
        }
        catch (LdapException e) {
            return -1;
        }
        if (dn0.equals(dn1)) {
            return 0;
        }
        return -1;
    }

    public Dn getDn(Object obj) throws LdapInvalidDnException {
        Dn dn = null;
        if (obj instanceof Dn) {
            dn = (Dn)obj;
            dn = dn.isNormalized() ? dn : dn.normalize(this.schemaManager);
        } else if (obj instanceof String) {
            dn = new Dn(this.schemaManager, (String)obj);
        } else {
            throw new IllegalStateException(I18n.err(I18n.ERR_04218, obj == null ? null : obj.getClass()));
        }
        return dn;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

