/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.model.schema.Normalizer;

public class SimpleNameComponentNormalizer
implements NameComponentNormalizer {
    private final Normalizer normalizer;

    public SimpleNameComponentNormalizer(Normalizer normalizer) {
        this.normalizer = normalizer;
    }

    public Object normalizeByName(String name, String val) throws LdapException {
        return this.normalizer.normalize(val);
    }

    public Object normalizeByName(String name, byte[] val) throws LdapException {
        return this.normalizer.normalize(new BinaryValue(val));
    }

    public Object normalizeByOid(String oid, String val) throws LdapException {
        return this.normalizer.normalize(val);
    }

    public Object normalizeByOid(String oid, byte[] val) throws LdapException {
        return this.normalizer.normalize(new BinaryValue(val));
    }

    public boolean isDefined(String oid) {
        return true;
    }

    public String normalizeName(String attributeName) throws LdapInvalidDnException {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_04216, new Object[0]));
    }
}

