/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RdnSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(RdnSerializer.class);

    private RdnSerializer() {
    }

    public static void serialize(Rdn rdn, ObjectOutput out) throws IOException {
        rdn.writeExternal(out);
        out.flush();
    }

    public static Rdn deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException, LdapInvalidDnException {
        Rdn rdn = new Rdn(schemaManager);
        try {
            rdn.readExternal(in);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        return rdn;
    }
}

