/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.ComplexDnParser;
import org.apache.directory.shared.ldap.model.name.FastDnParser;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.name.TooComplexException;

public final class RdnParser {
    private RdnParser() {
    }

    public static void parse(String dn, Rdn rdn) throws LdapInvalidDnException {
        try {
            FastDnParser.INSTANCE.parseRdn(dn, rdn);
        }
        catch (TooComplexException e) {
            rdn.clear();
            new ComplexDnParser().parseRdn(dn, rdn);
        }
    }

    public static boolean isValid(String dn) {
        Rdn rdn = new Rdn();
        try {
            RdnParser.parse(dn, rdn);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }
}

