/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.RdnParser;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.util.Chars;
import org.apache.directory.shared.util.Hex;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.Unicode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Rdn
implements Cloneable,
Externalizable,
Iterable<Ava> {
    protected static final Logger LOG = LoggerFactory.getLogger(Rdn.class);
    public static final Rdn EMPTY_RDN = new Rdn();
    private static final long serialVersionUID = 1L;
    private String upName = null;
    private String normName = null;
    private List<Ava> atavs = null;
    private MultiMap atavTypes = new MultiValueMap();
    private String atavType = null;
    protected Ava atav = null;
    private int nbAtavs = 0;
    public static final int UNDEFINED = Integer.MAX_VALUE;
    public static final int SUPERIOR = 1;
    public static final int INFERIOR = -1;
    public static final int EQUAL = 0;
    private boolean normalized = false;
    private SchemaManager schemaManager;

    public Rdn() {
        this((SchemaManager)null);
    }

    public Rdn(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.upName = "";
        this.normName = "";
        this.normalized = false;
    }

    public Rdn(SchemaManager schemaManager, String rdn) throws LdapInvalidDnException {
        if (Strings.isNotEmpty(rdn)) {
            RdnParser.parse(rdn, this);
            if (schemaManager != null) {
                this.schemaManager = schemaManager;
                this.normalize(schemaManager);
                this.normalized = true;
            } else {
                this.normalize();
                this.normalized = false;
            }
            this.upName = rdn;
        } else {
            this.upName = "";
            this.normName = "";
            this.normalized = false;
        }
    }

    public Rdn(String rdn) throws LdapInvalidDnException {
        this((SchemaManager)null, rdn);
    }

    public Rdn(SchemaManager schemaManager, String upType, String normType, String upValue, String normValue) throws LdapInvalidDnException {
        this.schemaManager = schemaManager;
        this.addAVA(schemaManager, upType, normType, new StringValue(upValue), new StringValue(normValue));
        this.upName = upType + '=' + upValue;
        this.normalize();
        this.normalized = schemaManager != null;
    }

    public Rdn(String upType, String normType, String upValue, String normValue) throws LdapInvalidDnException {
        this(null, upType, normType, upValue, normValue);
    }

    public Rdn(SchemaManager schemaManager, String upType, String upValue) throws LdapInvalidDnException {
        this.addAVA(schemaManager, upType, upType, new StringValue(upValue), new StringValue(upValue));
        this.upName = upType + '=' + upValue;
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            this.normalize(schemaManager);
            this.normalized = true;
        } else {
            this.normalize();
            this.normalized = false;
        }
    }

    public Rdn(String upType, String upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Rdn(Rdn rdn) {
        this.nbAtavs = rdn.getNbAtavs();
        this.normName = rdn.normName;
        this.upName = rdn.getName();
        this.normalized = rdn.normalized;
        switch (rdn.getNbAtavs()) {
            case 0: {
                return;
            }
            case 1: {
                this.atav = rdn.atav.clone();
                return;
            }
        }
        this.atavs = new ArrayList<Ava>();
        this.atavTypes = new MultiValueMap();
        for (Ava currentAtav : rdn.atavs) {
            this.atavs.add(currentAtav.clone());
            this.atavTypes.put((Object)currentAtav.getNormType(), (Object)currentAtav);
        }
    }

    void normalize() {
        switch (this.nbAtavs) {
            case 0: {
                this.normName = "";
                break;
            }
            case 1: {
                if (!this.atav.getNormValue().isBinary()) {
                    this.normName = this.atav.getNormName();
                    break;
                }
                this.normName = this.atav.getNormType() + "=#" + Strings.dumpHexPairs(this.atav.getNormValue().getBytes());
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (Ava ata : this.atavs) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append('+');
                    }
                    sb.append(ata.getNormName());
                }
                this.normName = sb.toString();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rdn normalize(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (this.normalized) {
            return this;
        }
        Rdn rdn = this;
        synchronized (rdn) {
            String savedUpName = this.getName();
            Dn.rdnOidToName(this, schemaManager.getNormalizerMapping());
            this.normalize();
            this.upName = savedUpName;
            this.normalized = true;
            return this;
        }
    }

    Rdn(SchemaManager schemaManager, String upName, String normName, Ava ... atavs) {
        this.upName = upName;
        this.normName = normName;
        this.schemaManager = schemaManager;
        boolean bl = this.normalized = schemaManager != null;
        if (atavs != null) {
            this.nbAtavs = atavs.length;
            switch (this.nbAtavs) {
                case 0: {
                    break;
                }
                case 1: {
                    this.atav = atavs[0];
                    this.atavTypes.put((Object)this.atav.getUpType(), (Object)this.atav);
                    this.atavTypes.put((Object)this.atav.getNormType(), (Object)this.atav);
                    break;
                }
                default: {
                    this.atavs = Arrays.asList(atavs);
                    for (Ava ava : atavs) {
                        this.atavTypes.put((Object)ava.getUpType(), (Object)ava);
                        this.atavTypes.put((Object)ava.getNormType(), (Object)ava);
                    }
                }
            }
        }
    }

    private void addAVA(SchemaManager schemaManager, String upType, String type, Value<?> upValue, Value<?> value) throws LdapInvalidDnException {
        Value<?> normalizedValue = value;
        String normalizedType = Strings.lowerCaseAscii(type);
        this.schemaManager = schemaManager;
        if (schemaManager != null) {
            OidNormalizer oidNormalizer = schemaManager.getNormalizerMapping().get(normalizedType);
            normalizedType = oidNormalizer.getAttributeTypeOid();
            try {
                normalizedValue = oidNormalizer.getNormalizer().normalize(value);
            }
            catch (LdapException e) {
                throw new LdapInvalidDnException(e.getMessage());
            }
        }
        switch (this.nbAtavs) {
            case 0: {
                this.atav = new Ava(schemaManager, upType, normalizedType, upValue, normalizedValue);
                this.nbAtavs = 1;
                this.atavType = normalizedType;
                return;
            }
            case 1: {
                this.atavs = new ArrayList<Ava>();
                this.atavs.add(this.atav);
                this.atavTypes = new MultiValueMap();
                this.atavTypes.put((Object)this.atavType, (Object)this.atav);
                this.atav = null;
            }
        }
        Ava newAtav = new Ava(schemaManager, upType, normalizedType, upValue, normalizedValue);
        this.atavs.add(newAtav);
        this.atavTypes.put((Object)normalizedType, (Object)newAtav);
        ++this.nbAtavs;
    }

    void addAVA(SchemaManager schemaManager, Ava value) {
        this.schemaManager = schemaManager;
        String normalizedType = value.getNormType();
        switch (this.nbAtavs) {
            case 0: {
                this.atav = value;
                this.nbAtavs = 1;
                this.atavType = normalizedType;
                return;
            }
            case 1: {
                this.atavs = new ArrayList<Ava>();
                this.atavs.add(this.atav);
                this.atavTypes = new MultiValueMap();
                this.atavTypes.put((Object)this.atavType, (Object)this.atav);
                this.atav = null;
            }
        }
        this.atavs.add(value);
        this.atavTypes.put((Object)normalizedType, (Object)value);
        ++this.nbAtavs;
    }

    void clear() {
        this.atav = null;
        this.atavs = null;
        this.atavType = null;
        this.atavTypes.clear();
        this.nbAtavs = 0;
        this.normName = "";
        this.upName = "";
        this.normalized = false;
    }

    public Object getValue(String type) throws LdapInvalidDnException {
        AttributeType attributeType;
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        if (this.schemaManager != null && (attributeType = this.schemaManager.getAttributeType(normalizedType)) != null) {
            normalizedType = attributeType.getOid();
        }
        switch (this.nbAtavs) {
            case 0: {
                return "";
            }
            case 1: {
                if (Strings.equals(this.atav.getNormType(), normalizedType)) {
                    return this.atav.getNormValue().get();
                }
                return "";
            }
        }
        if (this.atavTypes.containsKey((Object)normalizedType)) {
            Collection atavList = (Collection)this.atavTypes.get((Object)normalizedType);
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (Ava elem : atavList) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(elem.getNormValue());
            }
            return sb.toString();
        }
        return "";
    }

    public Ava getAttributeTypeAndValue(String type) {
        String normalizedType = Strings.lowerCaseAscii(Strings.trim(type));
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.atav.getNormType().equals(normalizedType)) {
                    return this.atav;
                }
                return null;
            }
        }
        if (this.atavTypes.containsKey((Object)normalizedType)) {
            Collection atavList = (Collection)this.atavTypes.get((Object)normalizedType);
            return (Ava)atavList.iterator().next();
        }
        return null;
    }

    @Override
    public Iterator<Ava> iterator() {
        if (this.nbAtavs == 1 || this.nbAtavs == 0) {
            return new Iterator<Ava>(){
                private boolean hasMoreElement;
                {
                    this.hasMoreElement = Rdn.this.nbAtavs == 1;
                }

                @Override
                public boolean hasNext() {
                    return this.hasMoreElement;
                }

                @Override
                public Ava next() {
                    Ava obj = Rdn.this.atav;
                    this.hasMoreElement = false;
                    return obj;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.atavs.iterator();
    }

    public Rdn clone() {
        try {
            Rdn rdn = (Rdn)super.clone();
            rdn.normalized = this.normalized;
            switch (rdn.getNbAtavs()) {
                case 0: {
                    break;
                }
                case 1: {
                    rdn.atav = this.atav.clone();
                    rdn.atavTypes = this.atavTypes;
                    break;
                }
                default: {
                    rdn.atavTypes = new MultiValueMap();
                    rdn.atavs = new ArrayList<Ava>();
                    for (Ava currentAtav : this.atavs) {
                        rdn.atavs.add(currentAtav.clone());
                        rdn.atavTypes.put((Object)currentAtav.getNormType(), (Object)currentAtav);
                    }
                }
            }
            return rdn;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public String getName() {
        return this.upName;
    }

    public String getNormName() {
        return this.normName == null ? "" : this.normName;
    }

    void setUpName(String upName) {
        this.upName = upName;
    }

    public int getNbAtavs() {
        return this.nbAtavs;
    }

    public Ava getAva() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav;
            }
        }
        return this.atavs.get(0).clone();
    }

    public String getUpType() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getUpType();
            }
        }
        return this.atavs.get(0).getUpType();
    }

    public String getNormType() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getNormType();
            }
        }
        return this.atavs.get(0).getNormType();
    }

    public Value<?> getUpValue() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getUpValue();
            }
        }
        return this.atavs.get(0).getUpValue();
    }

    public Value<?> getNormValue() {
        switch (this.nbAtavs) {
            case 0: {
                return null;
            }
            case 1: {
                return this.atav.getNormValue();
            }
        }
        return this.atavs.get(0).getNormValue();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Rdn)) {
            return false;
        }
        Rdn rdn = (Rdn)that;
        if (rdn.nbAtavs != this.nbAtavs) {
            return false;
        }
        switch (this.nbAtavs) {
            case 0: {
                return true;
            }
            case 1: {
                return this.atav.equals(rdn.atav);
            }
        }
        Iterator<Ava> localIterator = this.atavs.iterator();
        while (localIterator.hasNext()) {
            Iterator<Ava> paramIterator = rdn.atavs.iterator();
            Ava localAtav = localIterator.next();
            boolean equals = false;
            while (paramIterator.hasNext()) {
                Ava paramAtav = paramIterator.next();
                if (!localAtav.equals(paramAtav)) continue;
                equals = true;
                break;
            }
            if (equals) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.nbAtavs;
    }

    public static Object unescapeValue(String value) throws IllegalArgumentException {
        if (Strings.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        if (chars[0] == '#') {
            if (chars.length == 1) {
                return StringConstants.EMPTY_BYTES;
            }
            if (chars.length % 2 != 1) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04213, new Object[0]));
            }
            byte[] hexValue = new byte[(chars.length - 1) / 2];
            int pos = 0;
            for (int i = 1; i < chars.length; i += 2) {
                if (!Chars.isHex(chars, i) || !Chars.isHex(chars, i + 1)) {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_04214, new Object[0]));
                }
                hexValue[pos++] = Hex.getHexValue(chars[i], chars[i + 1]);
            }
            return hexValue;
        }
        boolean escaped = false;
        boolean isHex = false;
        int pair = -1;
        int pos = 0;
        byte[] bytes = new byte[chars.length * 6];
        block10: for (int i = 0; i < chars.length; ++i) {
            if (escaped) {
                escaped = false;
                switch (chars[i]) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '\\': {
                        bytes[pos++] = (byte)chars[i];
                        break;
                    }
                    default: {
                        if (!Chars.isHex(chars, i)) continue block10;
                        isHex = true;
                        pair = (byte)(Hex.getHexValue(chars[i]) << 4);
                        break;
                    }
                }
                continue;
            }
            if (isHex) {
                if (!Chars.isHex(chars, i)) continue;
                pair = (byte)(pair + Hex.getHexValue(chars[i]));
                bytes[pos++] = pair;
                continue;
            }
            switch (chars[i]) {
                case '\\': {
                    escaped = true;
                    continue block10;
                }
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': {
                    if (i != 0) {
                        bytes[pos++] = 35;
                        continue block10;
                    }
                }
                case '=': {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_04215, new Object[0]));
                }
                case ' ': {
                    if (i == 0 || i == chars.length - 1) {
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_04215, new Object[0]));
                    }
                    bytes[pos++] = 32;
                    continue block10;
                }
                default: {
                    if (chars[i] >= '\u0000' && chars[i] < '\u0080') {
                        bytes[pos++] = (byte)chars[i];
                        continue block10;
                    }
                    byte[] result = Unicode.charToBytes(chars[i]);
                    System.arraycopy(result, 0, bytes, pos, result.length);
                    pos += result.length;
                }
            }
        }
        return Strings.utf8ToString(bytes, pos);
    }

    public static String escapeValue(String value) {
        if (Strings.isEmpty(value)) {
            return "";
        }
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length * 3];
        int pos = 0;
        block8: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ' ': {
                    if (i > 0 && i < chars.length - 1) {
                        newChars[pos++] = chars[i];
                        continue block8;
                    }
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '#': {
                    if (i != 0) {
                        newChars[pos++] = chars[i];
                        continue block8;
                    }
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    newChars[pos++] = 92;
                    newChars[pos++] = chars[i];
                    continue block8;
                }
                case '\u007f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 55;
                    newChars[pos++] = 70;
                    continue block8;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 48;
                    newChars[pos++] = Strings.dumpHex((byte)(chars[i] & 0xF));
                    continue block8;
                }
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    newChars[pos++] = 92;
                    newChars[pos++] = 49;
                    newChars[pos++] = Strings.dumpHex((byte)(chars[i] & 0xF));
                    continue block8;
                }
                default: {
                    newChars[pos++] = chars[i];
                }
            }
        }
        return new String(newChars, 0, pos);
    }

    public static String escapeValue(byte[] attrValue) {
        if (Strings.isEmpty(attrValue)) {
            return "";
        }
        String value = Strings.utf8ToString(attrValue);
        return Rdn.escapeValue(value);
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public int hashCode() {
        int result = 37;
        switch (this.nbAtavs) {
            case 0: {
                break;
            }
            case 1: {
                result = result * 17 + this.atav.hashCode();
                break;
            }
            default: {
                for (Ava ata : this.atavs) {
                    result = result * 17 + ata.hashCode();
                }
            }
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.nbAtavs);
        out.writeUTF(this.upName);
        if (this.upName.equals(this.normName)) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.normName);
        }
        switch (this.nbAtavs) {
            case 0: {
                break;
            }
            case 1: {
                this.atav.writeExternal(out);
                break;
            }
            default: {
                for (Ava ava : this.atavs) {
                    ava.writeExternal(out);
                }
            }
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nbAtavs = in.readInt();
        this.upName = in.readUTF();
        this.normName = in.readUTF();
        if (Strings.isEmpty(this.normName)) {
            this.normName = this.upName;
        }
        switch (this.nbAtavs) {
            case 0: {
                this.atav = null;
                break;
            }
            case 1: {
                this.atav = new Ava(this.schemaManager);
                this.atav.readExternal(in);
                this.atavType = this.atav.getNormType();
                break;
            }
            default: {
                this.atavs = new ArrayList<Ava>();
                this.atavTypes = new MultiValueMap();
                for (int i = 0; i < this.nbAtavs; ++i) {
                    Ava ava = new Ava(this.schemaManager);
                    ava.readExternal(in);
                    this.atavs.add(ava);
                    this.atavTypes.put((Object)ava.getNormType(), (Object)ava);
                }
                this.atav = null;
                this.atavType = null;
            }
        }
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public String toString() {
        return this.upName == null ? "" : this.upName;
    }
}

