/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DnSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(DnSerializer.class);

    private DnSerializer() {
    }

    public static byte[] serialize(Dn dn) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        DnSerializer.serialize(dn, out);
        return baos.toByteArray();
    }

    public static void serialize(Dn dn, ObjectOutput out) throws IOException {
        dn.writeExternal(out);
        out.flush();
    }

    public static Dn deserialize(SchemaManager schemaManager, byte[] bytes) throws IOException, LdapInvalidDnException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bais);
        return DnSerializer.deserialize(schemaManager, in);
    }

    public static Dn deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException, LdapInvalidDnException {
        Dn dn = new Dn(schemaManager);
        try {
            dn.readExternal(in);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        return dn;
    }
}

