/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import java.util.List;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.ComplexDnParser;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.FastDnParser;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.name.TooComplexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DnParser {
    INSTANCE;


    public static DnParser getNameParser() {
        return INSTANCE;
    }

    public static void parseInternal(String name, List<Rdn> rdns) throws LdapInvalidDnException {
        try {
            FastDnParser.INSTANCE.parseDn(name, rdns);
        }
        catch (TooComplexException e) {
            rdns.clear();
            new ComplexDnParser().parseDn(name, rdns);
        }
    }

    public static boolean validateInternal(String name) {
        Dn dn = new Dn();
        try {
            DnParser.parseInternal(name, dn.rdns);
            return true;
        }
        catch (LdapInvalidDnException e) {
            return false;
        }
    }

    public Dn parse(String dn) throws LdapInvalidDnException {
        return new Dn(dn);
    }
}

