/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.name.DnParser;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dn
implements Iterable<Rdn>,
Externalizable {
    protected static final Logger LOG = LoggerFactory.getLogger(Dn.class);
    private static final long serialVersionUID = 1L;
    public static final int NOT_EQUAL = -1;
    public static final int EQUAL = 0;
    private boolean normalized;
    protected List<Rdn> rdns = new ArrayList<Rdn>(5);
    private String upName;
    private String normName;
    private byte[] bytes;
    public static final Dn EMPTY_DN = new Dn();
    public static final Dn ROOT_DSE = new Dn();
    private SchemaManager schemaManager;

    public Dn() {
        this((SchemaManager)null);
    }

    public Dn(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.upName = "";
        this.normName = "";
        this.normalized = true;
    }

    public Dn(String ... upRdns) throws LdapInvalidDnException {
        this((SchemaManager)null, upRdns);
    }

    public Dn(SchemaManager schemaManager, String ... upRdns) throws LdapInvalidDnException {
        StringBuilder sb = new StringBuilder();
        boolean valueExpected = false;
        boolean isFirst = true;
        for (String upRdn : upRdns) {
            if (Strings.isEmpty(upRdn)) continue;
            if (isFirst) {
                isFirst = false;
            } else if (!valueExpected) {
                sb.append(',');
            }
            if (!valueExpected) {
                sb.append(upRdn);
                if (upRdn.indexOf(61) != -1) continue;
                valueExpected = true;
                continue;
            }
            sb.append("=").append(upRdn);
            valueExpected = false;
        }
        if (!isFirst && valueExpected) {
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, I18n.err(I18n.ERR_04202, new Object[0]));
        }
        this.upName = sb.toString();
        DnParser.parseInternal(this.upName, this.rdns);
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            this.normalize(schemaManager);
        } else {
            this.normalized = false;
            this.normalizeInternal();
        }
    }

    Dn(SchemaManager schemaManager, String upName, String normName, Rdn ... rdns) {
        this.schemaManager = schemaManager;
        this.normalized = schemaManager != null || normName != null;
        this.upName = upName;
        this.normName = normName;
        this.bytes = Strings.getBytesUtf8(upName);
        this.rdns = Arrays.asList(rdns);
    }

    public Dn(Rdn ... rdns) {
        if (rdns == null) {
            return;
        }
        for (Rdn rdn : rdns) {
            this.rdns.add(rdn.clone());
        }
        this.normalizeInternal();
        this.toUpName();
        this.normalized = false;
    }

    public Dn(Rdn rdn, Dn dn) throws LdapInvalidDnException {
        if (dn == null || rdn == null) {
            throw new IllegalArgumentException("Either the dn or the rdn is null");
        }
        for (Rdn rdnParent : dn) {
            this.rdns.add(rdnParent);
        }
        this.rdns.add(rdn);
        this.schemaManager = dn.schemaManager;
        if (this.schemaManager != null) {
            this.normalize(this.schemaManager);
        } else {
            this.normalized = false;
            this.normalizeInternal();
        }
        this.toUpName();
    }

    public Dn(SchemaManager schemaManager, Dn dn) throws LdapInvalidDnException {
        if (dn == null) {
            throw new IllegalArgumentException("The dn is null");
        }
        for (Rdn rdnParent : dn) {
            this.rdns.add(rdnParent);
        }
        this.schemaManager = schemaManager;
        if (schemaManager != null) {
            this.normalize(schemaManager);
        } else {
            this.normalized = false;
            this.normalizeInternal();
        }
        this.toUpName();
    }

    public Dn(SchemaManager schemaManager, Rdn ... rdns) {
        if (rdns == null) {
            return;
        }
        for (Rdn rdn : rdns) {
            this.rdns.add(rdn.clone());
        }
        try {
            this.normalized = false;
            if (this.schemaManager != null) {
                this.normalize(schemaManager);
            }
            this.normalizeInternal();
            this.toUpName();
        }
        catch (LdapInvalidDnException lide) {
            throw new IllegalArgumentException(lide.getMessage());
        }
    }

    public static Dn normalize(SchemaManager schemaManager, String name) throws LdapInvalidDnException {
        if (name == null || name.length() == 0 || schemaManager == null) {
            return EMPTY_DN;
        }
        Dn newDn = new Dn(name);
        for (Rdn rdn : newDn.rdns) {
            String upName = rdn.getName();
            Dn.rdnOidToName(rdn, schemaManager.getNormalizerMapping());
            rdn.normalize();
            rdn.setUpName(upName);
        }
        newDn.normalizeInternal();
        newDn.normalized = true;
        return newDn;
    }

    void normalizeInternal() {
        this.normName = this.toNormName();
    }

    private String toNormName() {
        if (this.rdns.size() == 0) {
            this.bytes = null;
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (Rdn rdn : this.rdns) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(rdn.getNormName());
        }
        String newNormName = sb.toString();
        if (this.normName == null || !this.normName.equals(newNormName)) {
            this.bytes = Strings.getBytesUtf8(newNormName);
            this.normName = newNormName;
        }
        return this.normName;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public boolean hasSchemaManager() {
        return this.schemaManager != null;
    }

    public String toString() {
        return this.getName();
    }

    private String toUpName() {
        if (this.rdns.size() == 0) {
            this.upName = "";
        } else {
            StringBuffer sb = new StringBuffer();
            boolean isFirst = true;
            for (Rdn rdn : this.rdns) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(rdn.getName());
            }
            this.upName = sb.toString();
        }
        return this.upName;
    }

    private String getUpNamePrefix(int posn) {
        if (posn == 0) {
            return "";
        }
        if (posn > this.rdns.size()) {
            String message = I18n.err(I18n.ERR_04203, posn, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        int start = this.rdns.size() - posn;
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (int i = start; i < this.rdns.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(this.rdns.get(i).getName());
        }
        return sb.toString();
    }

    private String getUpNameSuffix(int posn) {
        if (posn > this.rdns.size()) {
            return "";
        }
        int end = this.rdns.size() - posn;
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (int i = 0; i < end; ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(this.rdns.get(i).getName());
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 37;
        for (Rdn rdn : this.rdns) {
            result = result * 17 + rdn.hashCode();
        }
        return result;
    }

    public String getName() {
        return this.upName == null ? "" : this.upName;
    }

    void setUpName(String upName) {
        this.upName = upName;
    }

    public String getNormName() {
        if (this.normName == null) {
            this.normName = this.toNormName();
        }
        return this.normName;
    }

    public int size() {
        return this.rdns.size();
    }

    public static int getNbBytes(Dn dn) {
        return dn.bytes == null ? 0 : dn.bytes.length;
    }

    public static byte[] getBytes(Dn dn) {
        return dn == null ? null : dn.bytes;
    }

    public boolean isAncestorOf(String dn) {
        try {
            return this.isAncestorOf(new Dn(dn));
        }
        catch (LdapInvalidDnException lide) {
            return false;
        }
    }

    public boolean isAncestorOf(Dn dn) {
        if (dn == null) {
            return false;
        }
        return dn.isDescendantOf(this);
    }

    public boolean isDescendantOf(String dn) {
        try {
            return this.isDescendantOf(new Dn(dn));
        }
        catch (LdapInvalidDnException lide) {
            return false;
        }
    }

    public boolean isDescendantOf(Dn dn) {
        if (dn == null || dn.isRootDSE()) {
            return true;
        }
        if (dn.size() > this.size()) {
            return false;
        }
        for (int i = dn.size() - 1; i >= 0; --i) {
            Rdn ldapRdn;
            Rdn nameRdn = dn.rdns.get(dn.rdns.size() - i - 1);
            if (nameRdn.equals(ldapRdn = this.rdns.get(this.rdns.size() - i - 1))) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.rdns.size() == 0;
    }

    public boolean isRootDSE() {
        return this.rdns.size() == 0;
    }

    public Rdn getRdn(int posn) {
        if (this.rdns.size() == 0) {
            return null;
        }
        Rdn rdn = this.rdns.get(this.rdns.size() - posn - 1);
        return rdn.clone();
    }

    public Rdn getRdn() {
        if (this.rdns.size() == 0) {
            return null;
        }
        return this.rdns.get(0).clone();
    }

    public List<Rdn> getRdns() {
        return UnmodifiableList.decorate(this.rdns);
    }

    public Dn getDescendantOf(String ancestor) throws LdapInvalidDnException {
        return this.getDescendantOf(new Dn(this.schemaManager, ancestor));
    }

    public Dn getDescendantOf(Dn ancestor) throws LdapInvalidDnException {
        int i;
        if (ancestor == null || ancestor.size() == 0) {
            return this;
        }
        if (this.rdns.size() == 0) {
            return EMPTY_DN;
        }
        int length = ancestor.size();
        if (length > this.rdns.size()) {
            String message = I18n.err(I18n.ERR_04206, length, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Dn newDn = new Dn(this.schemaManager);
        List<Rdn> rdnsAncestor = ancestor.getRdns();
        for (i = 0; i < ancestor.size(); ++i) {
            Rdn rdnDescendant;
            Rdn rdn = this.rdns.get(this.size() - 1 - i);
            if (rdn.equals(rdnDescendant = rdnsAncestor.get(ancestor.size() - 1 - i))) continue;
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX);
        }
        for (i = 0; i < this.rdns.size() - length; ++i) {
            newDn.rdns.add(this.rdns.get(i).clone());
        }
        newDn.toUpName();
        newDn.toNormName();
        newDn.normalized = this.normalized;
        return newDn;
    }

    public Dn getAncestorOf(String descendant) throws LdapInvalidDnException {
        return this.getAncestorOf(new Dn(this.schemaManager, descendant));
    }

    public Dn getAncestorOf(Dn descendant) throws LdapInvalidDnException {
        int i;
        if (descendant == null || descendant.size() == 0) {
            return this;
        }
        if (this.rdns.size() == 0) {
            return EMPTY_DN;
        }
        int length = descendant.size();
        if (length > this.rdns.size()) {
            String message = I18n.err(I18n.ERR_04206, length, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Dn newDn = new Dn(this.schemaManager);
        List<Rdn> rdnsDescendant = descendant.getRdns();
        for (i = 0; i < descendant.size(); ++i) {
            Rdn rdnDescendant;
            Rdn rdn = this.rdns.get(i);
            if (rdn.equals(rdnDescendant = rdnsDescendant.get(i))) continue;
            throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX);
        }
        for (i = length; i < this.rdns.size(); ++i) {
            newDn.rdns.add(this.rdns.get(i).clone());
        }
        newDn.toUpName();
        newDn.toNormName();
        newDn.normalized = this.normalized;
        return newDn;
    }

    public Dn getSuffix(int posn) {
        if (this.rdns.size() == 0) {
            return EMPTY_DN;
        }
        if (posn < 0 || posn > this.rdns.size()) {
            String message = I18n.err(I18n.ERR_04206, posn, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Dn newDn = new Dn();
        for (int i = 0; i < this.size() - posn; ++i) {
            newDn.rdns.add(this.rdns.get(i).clone());
        }
        newDn.normName = newDn.toNormName();
        newDn.upName = this.getUpNameSuffix(posn);
        return newDn;
    }

    public Dn addAllNormalized(int posn, Dn dn) throws LdapInvalidDnException {
        if (dn == null || dn.size() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        clonedDn.rdns.addAll(clonedDn.size() - posn, dn.rdns);
        if (Strings.isEmpty(this.normName)) {
            clonedDn.normName = dn.normName;
            clonedDn.bytes = dn.bytes;
            clonedDn.upName = dn.upName;
        } else {
            clonedDn.normName = dn.normName + "," + this.normName;
            clonedDn.bytes = Strings.getBytesUtf8(this.normName);
            clonedDn.upName = dn.upName + "," + this.upName;
        }
        return clonedDn;
    }

    public Dn addAll(Dn suffix) {
        Dn result = null;
        try {
            result = this.addAll(this.rdns.size(), suffix);
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            // empty catch block
        }
        return result;
    }

    public Dn addAll(int posn, Dn dn) throws LdapInvalidDnException {
        if (dn == null || dn.size() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        clonedDn.rdns.addAll(clonedDn.size() - posn, dn.rdns);
        if (clonedDn.isNormalized() && dn.isNormalized()) {
            if (clonedDn.size() != 0) {
                clonedDn.normName = dn.getNormName() + "," + this.normName;
                clonedDn.bytes = Strings.getBytesUtf8(this.normName);
                clonedDn.upName = dn.getName() + "," + this.upName;
            }
        } else {
            if (this.schemaManager != null) {
                clonedDn.normalize(this.schemaManager);
                this.normalizeInternal();
            } else {
                clonedDn.normalizeInternal();
                clonedDn.normalized = false;
            }
            clonedDn.toUpName();
        }
        return clonedDn;
    }

    public Dn add(String comp) throws LdapInvalidDnException {
        if (comp.length() == 0) {
            return this;
        }
        Dn clonedDn = this.copy();
        Rdn newRdn = new Rdn(this.schemaManager, comp);
        clonedDn.rdns.add(0, newRdn);
        if (this.schemaManager != null) {
            clonedDn.normalize(this.schemaManager);
        } else {
            clonedDn.normalizeInternal();
            clonedDn.normalized = false;
        }
        clonedDn.toUpName();
        clonedDn.toNormName();
        return clonedDn;
    }

    public Dn add(Rdn newRdn) {
        Dn clonedDn = this.copy();
        clonedDn.rdns.add(0, newRdn.clone());
        clonedDn.normalized = false;
        try {
            if (clonedDn.isNormalized() && newRdn.isNormalized()) {
                clonedDn.normalizeInternal();
            } else if (this.schemaManager != null) {
                clonedDn.normalize(this.schemaManager);
            } else {
                clonedDn.normalizeInternal();
                clonedDn.normalized = false;
            }
        }
        catch (LdapInvalidDnException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        clonedDn.toUpName();
        return clonedDn;
    }

    Dn addInternal(int posn, Rdn rdn) {
        if (posn < 0 || posn > this.size()) {
            String message = I18n.err(I18n.ERR_04206, posn, this.rdns.size());
            LOG.error(message);
            throw new ArrayIndexOutOfBoundsException(message);
        }
        Rdn newRdn = rdn.clone();
        int realPos = this.size() - posn;
        this.rdns.add(realPos, newRdn);
        this.toUpName();
        return this;
    }

    public Dn getParent() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.rdns.size() == 0) {
            return EMPTY_DN;
        }
        int posn = this.rdns.size() - 1;
        Dn newDn = new Dn(this.schemaManager);
        for (int i = this.rdns.size() - posn; i < this.rdns.size(); ++i) {
            newDn.rdns.add(this.rdns.get(i).clone());
        }
        newDn.normName = newDn.toNormName();
        newDn.upName = this.getUpNamePrefix(posn);
        newDn.normalized = this.normalized;
        return newDn;
    }

    private Dn copy() {
        Dn dn = new Dn(this.schemaManager);
        dn.normalized = this.normalized;
        dn.rdns = new ArrayList<Rdn>();
        for (Rdn rdn : this.rdns) {
            dn.rdns.add(rdn.clone());
        }
        return dn;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.normName.equals(obj);
        }
        if (obj instanceof Dn) {
            Dn name = (Dn)obj;
            if (name.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (name.rdns.get(i).equals(this.rdns.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Ava atavOidToName(Ava atav, Map<String, OidNormalizer> oidsMap) throws LdapInvalidDnException {
        String type = Strings.trim(atav.getNormType());
        if (type.startsWith("oid.") || type.startsWith("OID.")) {
            type = type.substring(4);
        }
        if (Strings.isNotEmpty(type)) {
            if (oidsMap == null) {
                return atav;
            }
            OidNormalizer oidNormalizer = oidsMap.get(type.toLowerCase());
            if (oidNormalizer != null) {
                try {
                    return new Ava(atav.getUpType(), oidNormalizer.getAttributeTypeOid(), atav.getUpValue(), oidNormalizer.getNormalizer().normalize(atav.getNormValue()), atav.getUpName());
                }
                catch (LdapException le) {
                    throw new LdapInvalidDnException(le.getMessage());
                }
            }
            return atav;
        }
        String msg = I18n.err(I18n.ERR_04209, new Object[0]);
        LOG.error(msg);
        throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, msg);
    }

    static void rdnOidToName(Rdn rdn, Map<String, OidNormalizer> oidsMap) throws LdapInvalidDnException {
        Rdn rdnCopy = rdn.clone();
        rdn.clear();
        for (Ava val : rdnCopy) {
            Ava newAtav = Dn.atavOidToName(val, oidsMap);
            rdn.addAVA(null, newAtav);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dn normalize(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (this.schemaManager == null) {
            this.schemaManager = schemaManager;
        }
        if (this.schemaManager != null) {
            if (this.normalized) {
                return this;
            }
            Dn dn = this;
            synchronized (dn) {
                if (this.size() == 0) {
                    this.normalized = true;
                    return this;
                }
                for (Rdn rdn : this.rdns) {
                    rdn.normalize(schemaManager);
                }
                this.normalizeInternal();
                this.normalized = true;
                return this;
            }
        }
        this.normalizeInternal();
        return this;
    }

    public static boolean isValid(String dn) {
        return DnParser.validateInternal(dn);
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public Iterator<Rdn> iterator() {
        return new RdnIterator();
    }

    public static boolean isNullOrEmpty(Dn dn) {
        if (dn != null) {
            return dn.isEmpty();
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.upName = in.readUTF();
        this.normName = in.readUTF();
        if (this.normName.length() == 0) {
            this.normName = this.upName;
        }
        int nbRdns = in.readInt();
        this.rdns = new ArrayList<Rdn>(nbRdns);
        for (int i = 0; i < nbRdns; ++i) {
            Rdn rdn = new Rdn(this.schemaManager);
            rdn.readExternal(in);
            this.rdns.add(rdn);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.upName == null) {
            String message = "Cannot serialize a NULL Dn";
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(this.upName);
        if (this.upName.equals(this.normName)) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.normName);
        }
        out.writeInt(this.size());
        for (Rdn rdn : this.rdns) {
            rdn.writeExternal(out);
        }
        out.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RdnIterator
    implements Iterator<Rdn> {
        int index;

        private RdnIterator() {
            this.index = Dn.this.rdns != null ? Dn.this.rdns.size() - 1 : -1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public Rdn next() {
            return this.index >= 0 ? Dn.this.rdns.get(this.index--) : null;
        }

        @Override
        public void remove() {
        }
    }
}

