/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.name;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Ava;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvaSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(AvaSerializer.class);

    private AvaSerializer() {
    }

    public static void serialize(Ava ava, ObjectOutput out) throws IOException {
        ava.writeExternal(out);
        out.flush();
    }

    public static Ava deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException, LdapInvalidDnException {
        Ava ava = new Ava(schemaManager);
        try {
            ava.readExternal(in);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        return ava;
    }
}

