/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.StringConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequestImpl
extends AbstractAbandonableRequest
implements ModifyRequest {
    static final long serialVersionUID = -505803669028990304L;
    private Dn name;
    private List<Modification> mods = new ArrayList<Modification>();
    private ModifyResponse response;

    public ModifyRequestImpl() {
        super(-1, TYPE);
    }

    public ModifyRequestImpl(int id) {
        super(id, TYPE);
    }

    @Override
    public Collection<Modification> getModifications() {
        return Collections.unmodifiableCollection(this.mods);
    }

    @Override
    public Dn getName() {
        return this.name;
    }

    @Override
    public void setName(Dn name) {
        this.name = name;
    }

    @Override
    public void addModification(Modification mod) {
        this.mods.add(mod);
    }

    private void addModification(ModificationOperation modOp, String attributeName, byte[] ... attributeValue) {
        DefaultEntryAttribute attr = new DefaultEntryAttribute(attributeName, attributeValue);
        this.addModification(attr, modOp);
    }

    private void addModification(ModificationOperation modOp, String attributeName, String ... attributeValue) {
        DefaultEntryAttribute attr = new DefaultEntryAttribute(attributeName, attributeValue);
        this.addModification(attr, modOp);
    }

    @Override
    public void addModification(EntryAttribute attr, ModificationOperation modOp) {
        this.mods.add(new DefaultModification(modOp, attr));
    }

    @Override
    public void add(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.ADD_ATTRIBUTE, attributeName, attributeValue);
    }

    @Override
    public void add(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.ADD_ATTRIBUTE, attributeName, attributeValue);
    }

    @Override
    public void add(EntryAttribute attr) {
        this.addModification(attr, ModificationOperation.ADD_ATTRIBUTE);
    }

    @Override
    public void replace(String attributeName) {
        this.addModification(ModificationOperation.REPLACE_ATTRIBUTE, attributeName, StringConstants.EMPTY_STRINGS);
    }

    @Override
    public void replace(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.REPLACE_ATTRIBUTE, attributeName, attributeValue);
    }

    @Override
    public void replace(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.REPLACE_ATTRIBUTE, attributeName, attributeValue);
    }

    @Override
    public void replace(EntryAttribute attr) {
        this.addModification(attr, ModificationOperation.REPLACE_ATTRIBUTE);
    }

    @Override
    public void removeModification(Modification mod) {
        this.mods.remove(mod);
    }

    @Override
    public void remove(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.REMOVE_ATTRIBUTE, attributeName, attributeValue);
    }

    @Override
    public void remove(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.REMOVE_ATTRIBUTE, attributeName, attributeValue);
    }

    @Override
    public void remove(EntryAttribute attr) {
        this.addModification(attr, ModificationOperation.REMOVE_ATTRIBUTE);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    @Override
    public ModifyResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ModifyResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        if (this.name != null) {
            hash = hash * 17 + this.name.hashCode();
        }
        hash = hash * 17 + this.mods.size();
        for (int i = 0; i < this.mods.size(); ++i) {
            hash = hash * 17 + ((DefaultModification)this.mods.get(i)).hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ModifyRequest req = (ModifyRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (req.getModifications().size() != this.mods.size()) {
            return false;
        }
        Iterator<Modification> list = req.getModifications().iterator();
        for (int i = 0; i < this.mods.size(); ++i) {
            Modification item = list.next();
            if (!(item == null ? this.mods.get(i) != null : !item.equals((DefaultModification)this.mods.get(i)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Modify Request\n");
        sb.append("        Object : '").append(this.name).append("'\n");
        if (this.mods != null) {
            for (int i = 0; i < this.mods.size(); ++i) {
                DefaultModification modification = (DefaultModification)this.mods.get(i);
                sb.append("            Modification[").append(i).append("]\n");
                sb.append("                Operation : ");
                switch (modification.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        sb.append(" add\n");
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        sb.append(" replace\n");
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        sb.append(" delete\n");
                    }
                }
                sb.append("                Modification\n");
                sb.append(modification.getAttribute());
            }
        }
        sb.append(super.toString());
        return super.toString(sb.toString());
    }
}

