/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.message;

import org.apache.directory.shared.ldap.model.message.AbstractRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedRequestImpl
extends AbstractRequest
implements ExtendedRequest<ExtendedResponse> {
    static final long serialVersionUID = 7916990159044177480L;
    private String oid;
    protected ExtendedResponseImpl response;

    public ExtendedRequestImpl() {
        super(-1, TYPE, true);
    }

    public ExtendedRequestImpl(int id) {
        super(id, TYPE, true);
    }

    @Override
    public String getRequestName() {
        return this.oid;
    }

    @Override
    public void setRequestName(String newOid) {
        this.oid = newOid;
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    @Override
    public ExtendedResponseImpl getResultResponse() {
        if (this.response == null) {
            this.response = new ExtendedResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        if (this.oid != null) {
            hash = hash * 17 + this.oid.hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ExtendedRequest)) {
            return false;
        }
        ExtendedRequest req = (ExtendedRequest)obj;
        if (this.oid != null && req.getRequestName() == null) {
            return false;
        }
        if (this.oid == null && req.getRequestName() != null) {
            return false;
        }
        return this.oid == null || req.getRequestName() == null || this.oid.equals(req.getRequestName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Extended request\n");
        sb.append("        Request name : '").append(this.oid).append("'\n");
        sb.append(super.toString());
        return super.toString(sb.toString());
    }
}

