/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.message;

import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareRequestImpl
extends AbstractAbandonableRequest
implements CompareRequest {
    static final long serialVersionUID = 1699731530016468977L;
    private Dn name;
    private String attrId;
    private Value<?> attrVal;
    private CompareResponse response;

    public CompareRequestImpl() {
        super(-1, TYPE);
    }

    public CompareRequestImpl(int id) {
        super(id, TYPE);
    }

    @Override
    public Dn getName() {
        return this.name;
    }

    @Override
    public void setName(Dn name) {
        this.name = name;
    }

    @Override
    public Value<?> getAssertionValue() {
        return this.attrVal;
    }

    @Override
    public void setAssertionValue(String value) {
        this.attrVal = new StringValue(value);
    }

    @Override
    public void setAssertionValue(byte[] value) {
        this.attrVal = value != null ? new BinaryValue(value) : null;
    }

    @Override
    public String getAttributeId() {
        return this.attrId;
    }

    @Override
    public void setAttributeId(String attributeId) {
        this.attrId = attributeId;
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    @Override
    public CompareResponse getResultResponse() {
        if (this.response == null) {
            this.response = new CompareResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public int hashCode() {
        Value<?> reqVal;
        int hash = 37;
        if (this.name != null) {
            hash = hash * 17 + this.name.hashCode();
        }
        if (this.attrId != null) {
            hash = hash * 17 + this.attrId.hashCode();
        }
        if (this.attrVal != null) {
            hash = hash * 17 + this.attrVal.hashCode();
        }
        if ((reqVal = this.getAssertionValue()) != null) {
            hash = hash * 17 + reqVal.hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompareRequest req = (CompareRequest)obj;
        Dn reqName = req.getName();
        if (this.name != null && reqName == null) {
            return false;
        }
        if (this.name == null && reqName != null) {
            return false;
        }
        if (this.name != null && reqName != null && !this.name.equals(req.getName())) {
            return false;
        }
        String reqId = req.getAttributeId();
        if (this.attrId != null && reqId == null) {
            return false;
        }
        if (this.attrId == null && reqId != null) {
            return false;
        }
        if (this.attrId != null && reqId != null && !this.attrId.equals(reqId)) {
            return false;
        }
        Value<?> reqVal = req.getAssertionValue();
        if (this.attrVal != null) {
            if (reqVal != null) {
                return this.attrVal.equals(reqVal);
            }
            return false;
        }
        return reqVal == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Compare request\n");
        sb.append("        Entry : '").append(this.name.toString()).append("'\n");
        sb.append("        Attribute description : '").append(this.attrId).append("'\n");
        sb.append("        Attribute value : '");
        if (!this.attrVal.isBinary()) {
            sb.append(this.attrVal.get());
        } else {
            byte[] binVal = this.attrVal.getBytes();
            sb.append(Strings.utf8ToString(binVal)).append('/').append(Strings.dumpBytes(binVal)).append("'\n");
        }
        sb.append(super.toString());
        return super.toString(sb.toString());
    }
}

