/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.message;

import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.AddResponseImpl;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRequestImpl
extends AbstractAbandonableRequest
implements AddRequest {
    static final long serialVersionUID = 7534132448349520346L;
    private Entry entry = new DefaultEntry();
    private AddResponse response;
    private EntryAttribute currentAttribute;

    public AddRequestImpl() {
        super(-1, TYPE);
    }

    public AddRequestImpl(int id) {
        super(id, TYPE);
    }

    public void addAttributeType(String type) throws LdapException {
        if (this.entry.get(type) != null) {
            this.currentAttribute = this.entry.get(type);
            return;
        }
        this.currentAttribute = new DefaultEntryAttribute(type);
        this.entry.put(this.currentAttribute);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getId();
    }

    public void addAttributeValue(String value) {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(Value<?> value) {
        this.currentAttribute.add(value);
    }

    public void addAttributeValue(byte[] value) {
        this.currentAttribute.add(new byte[][]{value});
    }

    @Override
    public Dn getEntryDn() {
        return this.entry.getDn();
    }

    @Override
    public void setEntryDn(Dn dn) {
        this.entry.setDn(dn);
    }

    @Override
    public Entry getEntry() {
        return this.entry;
    }

    @Override
    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    @Override
    public AddResponse getResultResponse() {
        if (this.response == null) {
            this.response = new AddResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AddRequest)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AddRequest req = (AddRequest)obj;
        if (this.entry == null) {
            return req.getEntry() == null;
        }
        return this.entry.equals(req.getEntry());
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + (this.entry == null ? 0 : this.entry.hashCode());
        hash = hash * 17 + (this.response == null ? 0 : this.response.hashCode());
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Add Request :\n");
        if (this.entry == null) {
            sb.append("            No entry\n");
        } else {
            sb.append(this.entry.toString());
        }
        return super.toString(sb.toString());
    }
}

