/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.message;

import java.util.Observable;
import java.util.Observer;
import org.apache.directory.shared.ldap.model.message.AbandonListener;
import org.apache.directory.shared.ldap.model.message.AbandonableRequest;
import org.apache.directory.shared.ldap.model.message.AbstractRequest;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;

public class AbstractAbandonableRequest
extends AbstractRequest
implements AbandonableRequest {
    static final long serialVersionUID = -4511116249089399040L;
    private boolean abandoned = false;
    private RequestObservable o;

    protected AbstractAbandonableRequest(int id, MessageTypeEnum type) {
        super(id, type, true);
    }

    public void abandon() {
        if (this.abandoned) {
            return;
        }
        this.abandoned = true;
        if (this.o == null) {
            this.o = new RequestObservable();
        }
        this.o.setChanged();
        this.o.notifyObservers();
        this.o.deleteObservers();
    }

    public boolean isAbandoned() {
        return this.abandoned;
    }

    public void addAbandonListener(final AbandonListener listener) {
        if (this.o == null) {
            this.o = new RequestObservable();
        }
        this.o.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                listener.requestAbandoned(AbstractAbandonableRequest.this);
            }
        });
    }

    class RequestObservable
    extends Observable {
        RequestObservable() {
        }

        public void setChanged() {
            super.setChanged();
        }
    }
}

