/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.ldif;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.EntrySerializer;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationSerializer;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.ldif.ChangeType;
import org.apache.directory.shared.ldap.model.ldif.LdifControl;
import org.apache.directory.shared.ldap.model.ldif.LdifControlSerializer;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.DnSerializer;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Unicode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifEntrySerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(LdifEntrySerializer.class);

    private LdifEntrySerializer() {
    }

    public static void serialize(LdifEntry ldifEntry, ObjectOutput out) throws IOException {
        out.writeInt(ldifEntry.getChangeType().getChangeType());
        switch (ldifEntry.getChangeType()) {
            case Add: {
                EntrySerializer.serialize(ldifEntry.getEntry(), out);
                break;
            }
            case Delete: {
                DnSerializer.serialize(ldifEntry.getDn(), out);
                break;
            }
            case ModDn: 
            case ModRdn: {
                DnSerializer.serialize(ldifEntry.getDn(), out);
                out.writeBoolean(ldifEntry.isDeleteOldRdn());
                if (ldifEntry.getNewRdn() != null) {
                    out.writeBoolean(true);
                    Unicode.writeUTF(out, ldifEntry.getNewRdn());
                } else {
                    out.writeBoolean(false);
                }
                if (ldifEntry.getNewSuperior() != null) {
                    out.writeBoolean(true);
                    Unicode.writeUTF(out, ldifEntry.getNewSuperior());
                    break;
                }
                out.writeBoolean(false);
                break;
            }
            case Modify: {
                DnSerializer.serialize(ldifEntry.getDn(), out);
                out.writeInt(ldifEntry.getModificationItems().size());
                for (Modification modification : ldifEntry.getModificationItems()) {
                    ModificationSerializer.serialize(modification, out);
                }
                break;
            }
        }
        if (ldifEntry.hasControls()) {
            out.writeInt(ldifEntry.getControls().size());
            for (LdifControl ldifControl : ldifEntry.getControls().values()) {
                LdifControlSerializer.serialize(ldifControl, out);
            }
        } else {
            out.writeInt(0);
        }
        out.flush();
    }

    public static LdifEntry deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException, LdapInvalidDnException {
        ChangeType changeType = ChangeType.getChangeType(in.readInt());
        LdifEntry ldifEntry = null;
        switch (changeType) {
            case Add: {
                Entry entry = EntrySerializer.deserialize(schemaManager, in);
                ldifEntry = new LdifEntry(entry);
                ldifEntry.setChangeType(changeType);
                break;
            }
            case Delete: {
                Dn dn = DnSerializer.deserialize(schemaManager, in);
                ldifEntry = new LdifEntry();
                ldifEntry.setChangeType(changeType);
                ldifEntry.setDn(dn);
                break;
            }
            case ModDn: 
            case ModRdn: {
                ldifEntry = new LdifEntry();
                Dn dn = DnSerializer.deserialize(schemaManager, in);
                ldifEntry.setDn(dn);
                boolean deleteOldRdn = in.readBoolean();
                ldifEntry.setChangeType(changeType);
                ldifEntry.setDeleteOldRdn(deleteOldRdn);
                if (in.readBoolean()) {
                    String newRdn = Unicode.readUTF(in);
                    ldifEntry.setNewRdn(newRdn);
                }
                if (!in.readBoolean()) break;
                String newSuperior = Unicode.readUTF(in);
                ldifEntry.setNewSuperior(newSuperior);
                break;
            }
            case Modify: {
                ldifEntry = new LdifEntry();
                Dn dn = DnSerializer.deserialize(schemaManager, in);
                ldifEntry.setDn(dn);
                int nbModifs = in.readInt();
                ldifEntry.setChangeType(changeType);
                for (int i = 0; i < nbModifs; ++i) {
                    DefaultModification modification = new DefaultModification();
                    try {
                        modification.readExternal(in);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IOException(cnfe.getMessage());
                    }
                    ldifEntry.addModificationItem(modification);
                }
                break;
            }
        }
        int nbControls = in.readInt();
        if (nbControls > 0) {
            for (int i = 0; i < nbControls; ++i) {
                LdifControl ldifControl = LdifControlSerializer.deserialize(in);
                ldifEntry.addControl(ldifControl);
            }
        }
        return ldifEntry;
    }
}

