/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.ldif;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.ldif.ChangeType;
import org.apache.directory.shared.ldap.model.ldif.LdifControl;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.util.Unicode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifEntry
implements Cloneable {
    public static final Modification[] EMPTY_MODS = new Modification[0];
    private ChangeType changeType = ChangeType.None;
    private List<Modification> modificationList = new LinkedList<Modification>();
    private Map<String, Modification> modificationItems = new HashMap<String, Modification>();
    private String newSuperior;
    private String newRdn;
    private boolean deleteOldRdn;
    private Entry entry;
    private Map<String, LdifControl> controls;

    public LdifEntry() {
        this.entry = new DefaultEntry((Dn)null);
        this.controls = null;
    }

    public LdifEntry(Entry entry) {
        this.entry = entry;
        this.controls = null;
    }

    public void setDn(Dn dn) {
        this.entry.setDn(dn);
    }

    public void setDn(String dn) throws LdapInvalidDnException {
        this.entry.setDn(new Dn(dn));
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public void setChangeType(String changeType) {
        if ("add".equals(changeType)) {
            this.changeType = ChangeType.Add;
        } else if ("modify".equals(changeType)) {
            this.changeType = ChangeType.Modify;
        } else if ("moddn".equals(changeType)) {
            this.changeType = ChangeType.ModDn;
        } else if ("modrdn".equals(changeType)) {
            this.changeType = ChangeType.ModRdn;
        } else if ("delete".equals(changeType)) {
            this.changeType = ChangeType.Delete;
        }
    }

    public void addModificationItem(Modification modification) {
        if (this.changeType == ChangeType.Modify) {
            this.modificationList.add(modification);
            this.modificationItems.put(modification.getAttribute().getId(), modification);
        }
    }

    public void addModificationItem(ModificationOperation modOp, EntryAttribute attr) {
        if (this.changeType == ChangeType.Modify) {
            DefaultModification item = new DefaultModification(modOp, attr);
            this.modificationList.add(item);
            this.modificationItems.put(attr.getId(), item);
        }
    }

    public void addModificationItem(ModificationOperation modOp, String id, Object value) {
        if (this.changeType == ChangeType.Modify) {
            EntryAttribute attr;
            if (value == null) {
                value = new StringValue((String)null);
                attr = new DefaultEntryAttribute(id, (Value)value);
            } else {
                attr = (EntryAttribute)value;
            }
            DefaultModification item = new DefaultModification(modOp, attr);
            this.modificationList.add(item);
            this.modificationItems.put(id, item);
        }
    }

    public void addAttribute(EntryAttribute attr) throws LdapException {
        this.entry.put(attr);
    }

    public void addAttribute(String id, Object ... values) throws LdapException {
        if (values != null) {
            for (Object value : values) {
                if (value instanceof String) {
                    this.entry.add(id, (String)value);
                    continue;
                }
                this.entry.add(id, (byte[][])new byte[][]{(byte[])value});
            }
        } else {
            this.entry.add(id, new Value[]{null});
        }
    }

    public List<EntryAttribute> removeAttribute(String ... ids) {
        if (this.entry.containsAttribute(ids)) {
            return this.entry.removeAttributes(ids);
        }
        return null;
    }

    public void putAttribute(String id, Object value) throws LdapException {
        if (value instanceof String) {
            this.entry.add(id, (String)value);
        } else {
            this.entry.add(id, (byte[][])new byte[][]{(byte[])value});
        }
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public List<Modification> getModificationItems() {
        return this.modificationList;
    }

    public Modification[] getModificationItemsArray() {
        return this.modificationList.toArray(EMPTY_MODS);
    }

    public Dn getDn() {
        return this.entry.getDn();
    }

    public int size() {
        return this.modificationList.size();
    }

    public EntryAttribute get(String attributeId) {
        if ("dn".equalsIgnoreCase(attributeId)) {
            return new DefaultEntryAttribute("dn", this.entry.getDn().getName());
        }
        return this.entry.get(attributeId);
    }

    public Entry getEntry() {
        if (this.isEntry()) {
            return this.entry;
        }
        return null;
    }

    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(String newSuperior) {
        this.newSuperior = newSuperior;
    }

    public boolean isLdifContent() {
        return this.changeType == ChangeType.None;
    }

    public boolean isLdifChange() {
        return this.changeType != ChangeType.None;
    }

    public boolean isChangeAdd() {
        return this.changeType == ChangeType.Add;
    }

    public boolean isChangeDelete() {
        return this.changeType == ChangeType.Delete;
    }

    public boolean isChangeModDn() {
        return this.changeType == ChangeType.ModDn;
    }

    public boolean isChangeModRdn() {
        return this.changeType == ChangeType.ModRdn;
    }

    public boolean isChangeModify() {
        return this.changeType == ChangeType.Modify;
    }

    public boolean isEntry() {
        return this.changeType == ChangeType.None || this.changeType == ChangeType.Add;
    }

    public boolean hasControls() {
        return this.controls != null;
    }

    public Map<String, LdifControl> getControls() {
        return this.controls;
    }

    public LdifControl getControl(String oid) {
        if (this.controls != null) {
            return this.controls.get(oid);
        }
        return null;
    }

    public void addControl(Control ... controls) {
        if (controls == null) {
            throw new IllegalArgumentException("The added control must not be null");
        }
        for (Control control : controls) {
            if (this.changeType == ChangeType.None) {
                this.changeType = ChangeType.Add;
            }
            if (this.controls == null) {
                this.controls = new ConcurrentHashMap<String, LdifControl>();
            }
            if (control instanceof LdifControl) {
                this.controls.put(control.getOid(), (LdifControl)control);
                continue;
            }
            LdifControl ldifControl = new LdifControl(control.getOid());
            ldifControl.setCritical(control.isCritical());
            this.controls.put(control.getOid(), new LdifControl(control.getOid()));
        }
    }

    public LdifEntry clone() throws CloneNotSupportedException {
        LdifEntry clone = (LdifEntry)super.clone();
        if (this.modificationList != null) {
            for (Modification modif : this.modificationList) {
                DefaultModification modifClone = new DefaultModification(modif.getOperation(), modif.getAttribute().clone());
                clone.modificationList.add(modifClone);
            }
        }
        if (this.modificationItems != null) {
            for (String key : this.modificationItems.keySet()) {
                Modification modif = this.modificationItems.get(key);
                DefaultModification modifClone = new DefaultModification(modif.getOperation(), modif.getAttribute().clone());
                clone.modificationItems.put(key, modifClone);
            }
        }
        if (this.entry != null) {
            clone.entry = this.entry.clone();
        }
        return clone;
    }

    public String toString() {
        try {
            return LdifUtils.convertToLdif(this);
        }
        catch (LdapException ne) {
            return "";
        }
    }

    public int hashCode() {
        int result = 37;
        if (this.entry != null && this.entry.getDn() != null) {
            result = result * 17 + this.entry.getDn().hashCode();
        }
        if (this.changeType != null) {
            result = result * 17 + this.changeType.hashCode();
            switch (this.changeType) {
                case Add: {
                    if (this.entry == null) break;
                    result = result * 17 + this.entry.hashCode();
                    break;
                }
                case Delete: {
                    break;
                }
                case Modify: {
                    if (this.modificationList == null) break;
                    result = result * 17 + ((Object)this.modificationList).hashCode();
                    for (Modification modification : this.modificationList) {
                        result = result * 17 + modification.hashCode();
                    }
                    break;
                }
                case ModDn: 
                case ModRdn: {
                    result *= 17;
                    result = this.deleteOldRdn ? ++result : --result;
                    if (this.newRdn != null) {
                        result = result * 17 + this.newRdn.hashCode();
                    }
                    if (this.newSuperior == null) break;
                    result = result * 17 + this.newSuperior.hashCode();
                    break;
                }
            }
        }
        if (this.controls != null) {
            for (String control : this.controls.keySet()) {
                result = result * 17 + control.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        Dn dnEntry;
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LdifEntry)) {
            return false;
        }
        LdifEntry otherEntry = (LdifEntry)o;
        Dn thisDn = this.entry.getDn();
        if (!thisDn.equals(dnEntry = otherEntry.getDn())) {
            return false;
        }
        if (this.changeType != otherEntry.changeType) {
            return false;
        }
        switch (this.changeType) {
            case Add: {
                if (this.entry.size() != otherEntry.entry.size()) {
                    return false;
                }
                if (this.entry.equals(otherEntry.entry)) break;
                return false;
            }
            case Delete: {
                break;
            }
            case Modify: {
                if (this.modificationList == null) {
                    if (otherEntry.modificationList == null) break;
                    return false;
                }
                if (otherEntry.modificationList == null) {
                    return false;
                }
                if (this.modificationList.size() != otherEntry.modificationList.size()) {
                    return false;
                }
                int i = 0;
                for (Modification modification : this.modificationList) {
                    if (!modification.equals(otherEntry.modificationList.get(i))) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
            case ModDn: 
            case ModRdn: {
                if (this.deleteOldRdn != otherEntry.deleteOldRdn) {
                    return false;
                }
                try {
                    Rdn thisNewRdn = new Rdn(this.newRdn);
                    Rdn entryNewRdn = new Rdn(otherEntry.newRdn);
                    if (!thisNewRdn.equals(entryNewRdn)) {
                        return false;
                    }
                }
                catch (LdapInvalidDnException ine) {
                    return false;
                }
                try {
                    Dn thisNewSuperior = new Dn(this.newSuperior);
                    Dn entryNewSuperior = new Dn(otherEntry.newSuperior);
                    if (!thisNewSuperior.equals(entryNewSuperior)) {
                        return false;
                    }
                    break;
                }
                catch (LdapInvalidDnException ine) {
                    return false;
                }
            }
        }
        if (this.controls != null) {
            Map<String, LdifControl> otherControls = otherEntry.controls;
            if (otherControls == null) {
                return false;
            }
            if (this.controls.size() != otherControls.size()) {
                return false;
            }
            for (String controlOid : this.controls.keySet()) {
                if (!otherControls.containsKey(controlOid)) {
                    return false;
                }
                Control thisControl = this.controls.get(controlOid);
                Control otherControl = otherControls.get(controlOid);
                if (!(thisControl == null ? otherControl != null : !thisControl.equals(otherControl))) continue;
                return false;
            }
            return true;
        }
        return otherEntry.controls == null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int nbControls;
        int i;
        int type = in.readInt();
        this.changeType = ChangeType.getChangeType(type);
        this.entry = (Entry)in.readObject();
        switch (this.changeType) {
            case Add: 
            case Delete: {
                break;
            }
            case ModDn: 
            case ModRdn: {
                this.deleteOldRdn = in.readBoolean();
                if (in.readBoolean()) {
                    this.newRdn = Unicode.readUTF(in);
                }
                if (!in.readBoolean()) break;
                this.newSuperior = Unicode.readUTF(in);
                break;
            }
            case Modify: {
                int nbModifs = in.readInt();
                for (i = 0; i < nbModifs; ++i) {
                    int operation = in.readInt();
                    String modStr = Unicode.readUTF(in);
                    DefaultEntryAttribute value = (DefaultEntryAttribute)in.readObject();
                    this.addModificationItem(ModificationOperation.getOperation(operation), modStr, value);
                }
                break;
            }
        }
        if (in.available() > 0 && (nbControls = in.readInt()) > 0) {
            this.controls = new ConcurrentHashMap<String, LdifControl>(nbControls);
            for (i = 0; i < nbControls; ++i) {
                String controlOid = in.readUTF();
                boolean isCritical = in.readBoolean();
                boolean hasValue = in.readBoolean();
                LdifControl control = new LdifControl(controlOid);
                control.setCritical(isCritical);
                if (hasValue) {
                    int valueLength = in.readInt();
                    byte[] value = new byte[valueLength];
                    if (valueLength > 0) {
                        in.read(value);
                    }
                    control.setValue(value);
                }
                this.controls.put(controlOid, control);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.changeType.getChangeType());
        out.writeObject(this.entry);
        switch (this.changeType) {
            case Add: 
            case Delete: {
                break;
            }
            case ModDn: 
            case ModRdn: {
                out.writeBoolean(this.deleteOldRdn);
                if (this.newRdn != null) {
                    out.writeBoolean(true);
                    Unicode.writeUTF(out, this.newRdn);
                } else {
                    out.writeBoolean(false);
                }
                if (this.newSuperior != null) {
                    out.writeBoolean(true);
                    Unicode.writeUTF(out, this.newSuperior);
                    break;
                }
                out.writeBoolean(false);
                break;
            }
            case Modify: {
                out.writeInt(this.modificationList.size());
                for (Modification modification : this.modificationList) {
                    out.writeInt(modification.getOperation().getValue());
                    Unicode.writeUTF(out, modification.getAttribute().getId());
                    EntryAttribute attribute = modification.getAttribute();
                    out.writeObject(attribute);
                }
                break;
            }
        }
        if (this.controls != null) {
            out.writeInt(this.controls.size());
            for (LdifControl control : this.controls.values()) {
                Unicode.writeUTF(out, control.getOid());
                out.writeBoolean(control.isCritical());
                out.writeBoolean(control.hasValue());
                if (!control.hasValue()) continue;
                out.writeInt(control.getValue().length);
                if (control.getValue().length <= 0) continue;
                out.write(control.getValue());
            }
        }
        out.flush();
    }
}

