/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.ldif;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.model.ldif.LdifControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifControlSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(LdifControlSerializer.class);

    private LdifControlSerializer() {
    }

    public static void serialize(LdifControl ldifControl, ObjectOutput out) throws IOException {
        out.writeUTF(ldifControl.getOid());
        out.writeBoolean(ldifControl.isCritical());
        if (ldifControl.hasValue()) {
            out.writeInt(ldifControl.getValue().length);
            out.write(ldifControl.getValue());
        } else {
            out.writeInt(-1);
        }
        out.flush();
    }

    public static LdifControl deserialize(ObjectInput in) throws IOException {
        String oid = in.readUTF();
        LdifControl ldifControl = new LdifControl(oid);
        ldifControl.setCritical(in.readBoolean());
        int valueSize = in.readInt();
        if (valueSize >= 0) {
            byte[] value = new byte[valueSize];
            in.read(value);
            ldifControl.setValue(value);
        }
        return ldifControl;
    }
}

