/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.ldif;

import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.util.Strings;

public class LdifControl
implements Control {
    private String oid;
    private boolean criticality = false;
    protected byte[] value;

    public LdifControl(String oid) {
        this.oid = oid;
    }

    public String toString() {
        return "LdifControl : {" + this.getOid() + ", " + this.isCritical() + ", " + Strings.dumpBytes(this.getValue()) + "}";
    }

    public String getOid() {
        return this.oid;
    }

    public boolean isCritical() {
        return this.criticality;
    }

    public void setCritical(boolean criticality) {
        this.criticality = criticality;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public int hashCode() {
        int h = 17;
        h = h * 37 + (this.criticality ? 1 : 0);
        h = h * 37 + (this.oid == null ? 0 : this.oid.hashCode());
        if (this.value != null) {
            for (byte v : this.value) {
                h = h * 37 + v;
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Control)) {
            return false;
        }
        Control otherControl = (Control)o;
        if (!this.oid.equalsIgnoreCase(otherControl.getOid())) {
            return false;
        }
        return this.criticality == otherControl.isCritical();
    }
}

