/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.filter;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.filter.AssertionType;
import org.apache.directory.shared.ldap.model.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExprNode
implements ExprNode {
    protected Map<String, Object> annotations;
    protected final AssertionType assertionType;
    protected boolean isSchemaAware;

    protected AbstractExprNode(AssertionType assertionType) {
        this.assertionType = assertionType;
    }

    @Override
    public AssertionType getAssertionType() {
        return this.assertionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExprNode)) {
            return false;
        }
        AbstractExprNode that = (AbstractExprNode)o;
        if (this.assertionType != that.assertionType) {
            return false;
        }
        if (this.annotations == null) {
            return that.annotations == null;
        }
        if (that.annotations == null) {
            return false;
        }
        for (String key : this.annotations.keySet()) {
            if (!that.annotations.containsKey(key)) {
                return false;
            }
            Object thisAnnotation = this.annotations.get(key);
            Object thatAnnotation = that.annotations.get(key);
            if (!(thisAnnotation == null ? thatAnnotation != null : !thisAnnotation.equals(thatAnnotation))) continue;
            return false;
        }
        return true;
    }

    protected static Value<?> escapeFilterValue(Value<?> value) {
        if (value.isNull()) {
            return value;
        }
        StringBuilder sb = null;
        if (value.isBinary()) {
            sb = new StringBuilder(((byte[])((BinaryValue)((Object)value)).getReference()).length * 3);
            for (byte b : (byte[])((BinaryValue)((Object)value)).getReference()) {
                if (b < 127 && b >= 0) {
                    switch (b) {
                        case 42: {
                            sb.append("\\2A");
                            break;
                        }
                        case 40: {
                            sb.append("\\28");
                            break;
                        }
                        case 41: {
                            sb.append("\\29");
                            break;
                        }
                        case 92: {
                            sb.append("\\5C");
                            break;
                        }
                        case 0: {
                            sb.append("\\00");
                            break;
                        }
                        default: {
                            sb.append((char)b);
                            break;
                        }
                    }
                    continue;
                }
                sb.append('\\');
                String digit = Integer.toHexString(b & 0xFF);
                if (digit.length() == 1) {
                    sb.append('0');
                }
                sb.append(digit.toUpperCase());
            }
            return new StringValue(sb.toString());
        }
        String val = ((StringValue)value).getString();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            String replace = null;
            switch (ch) {
                case '*': {
                    replace = "\\2A";
                    break;
                }
                case '(': {
                    replace = "\\28";
                    break;
                }
                case ')': {
                    replace = "\\29";
                    break;
                }
                case '\\': {
                    replace = "\\5C";
                    break;
                }
                case '\u0000': {
                    replace = "\\00";
                }
            }
            if (replace != null) {
                if (sb == null) {
                    sb = new StringBuilder(val.length() * 2);
                    sb.append(val.substring(0, i));
                }
                sb.append(replace);
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? value : new StringValue(sb.toString());
    }

    public int hashCode() {
        int h = 37;
        if (this.annotations != null) {
            for (String key : this.annotations.keySet()) {
                Object value = this.annotations.get(key);
                h = h * 17 + key.hashCode();
                h = h * 17 + (value == null ? 0 : value.hashCode());
            }
        }
        return h;
    }

    @Override
    public Object get(Object key) {
        if (null == this.annotations) {
            return null;
        }
        return this.annotations.get(key);
    }

    @Override
    public void set(String key, Object value) {
        if (null == this.annotations) {
            this.annotations = new HashMap<String, Object>(2);
        }
        this.annotations.put(key, value);
    }

    protected Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isSchemaAware() {
        return this.isSchemaAware;
    }

    @Override
    public StringBuilder printRefinementToBuffer(StringBuilder buf) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_04144, new Object[0]));
    }

    @Override
    public ExprNode clone() {
        try {
            ExprNode clone = (ExprNode)super.clone();
            if (this.annotations != null) {
                for (String key : this.annotations.keySet()) {
                    Object value = this.annotations.get(key);
                    ((AbstractExprNode)clone).annotations.put(key, value);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        if (null != this.annotations && this.annotations.containsKey("count")) {
            return ":[" + this.annotations.get("count") + "]";
        }
        return "";
    }
}

