/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.AbstractValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.exception.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringValue
extends AbstractValue<String> {
    private static final long serialVersionUID = 2L;

    public StringValue() {
        this.normalized = false;
        this.valid = null;
    }

    public StringValue(AttributeType attributeType) {
        if (attributeType != null) {
            if (attributeType.getSyntax() == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04445, new Object[0]));
            }
            if (!attributeType.getSyntax().isHumanReadable()) {
                LOG.warn("Treating a value of a binary attribute {} as a String: \nthis could cause data corruption!", (Object)attributeType.getName());
            }
            this.attributeType = attributeType;
        }
    }

    public StringValue(String value) {
        this.wrappedValue = value;
        this.normalized = false;
        this.valid = null;
    }

    public StringValue(AttributeType attributeType, String value) {
        this(attributeType);
        this.wrappedValue = value;
    }

    @Override
    public String get() {
        return (String)this.wrappedValue;
    }

    @Override
    public String getNormalizedValue() {
        if (this.isNull()) {
            this.normalized = true;
            return null;
        }
        if (!this.normalized) {
            try {
                this.normalize();
            }
            catch (LdapException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.info(message);
                this.normalized = false;
            }
        }
        if (this.normalizedValue == null) {
            return (String)this.wrappedValue;
        }
        return (String)this.normalizedValue;
    }

    @Override
    public void normalize() throws LdapException {
        if (this.normalized) {
            return;
        }
        if (this.attributeType != null) {
            Normalizer normalizer = this.getNormalizer();
            this.normalizedValue = normalizer == null ? this.wrappedValue : normalizer.normalize((String)this.wrappedValue);
            this.normalized = true;
        }
    }

    @Override
    public final void normalize(Normalizer normalizer) throws LdapException {
        if (normalizer != null) {
            this.normalizedValue = normalizer.normalize((String)this.wrappedValue);
            this.normalized = true;
        }
    }

    @Override
    public int compareTo(Value<String> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        if (!(value instanceof StringValue)) {
            String message = I18n.err(I18n.ERR_04128, this.toString(), value.getClass());
            LOG.error(message);
            throw new NotImplementedException(message);
        }
        StringValue stringValue = (StringValue)value;
        if (this.attributeType != null) {
            if (stringValue.getAttributeType() == null) {
                return this.getNormalizedValue().compareTo(stringValue.getNormalizedValue());
            }
            if (!this.attributeType.equals(stringValue.getAttributeType())) {
                String message = I18n.err(I18n.ERR_04128, this.toString(), value.getClass());
                LOG.error(message);
                throw new NotImplementedException(message);
            }
        } else {
            return this.getNormalizedValue().compareTo(stringValue.getNormalizedValue());
        }
        try {
            return this.getLdapComparator().compare(this.getNormalizedValue(), stringValue.getNormalizedValue());
        }
        catch (LdapException e) {
            String msg = I18n.err(I18n.ERR_04443, this, value);
            LOG.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    @Override
    public StringValue clone() {
        return (StringValue)super.clone();
    }

    public int hashCode() {
        if (this.h == 0) {
            if (this.isNull()) {
                return 0;
            }
            String normalized = this.getNormalizedValue();
            this.h = normalized != null ? normalized.hashCode() : 17;
        }
        return this.h;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringValue)) {
            return false;
        }
        StringValue other = (StringValue)obj;
        if (this.isNull()) {
            return other.isNull();
        }
        if (this.wrappedValue == other.wrappedValue) {
            return true;
        }
        if (this.wrappedValue != null && ((String)this.wrappedValue).equals(other.wrappedValue)) {
            return true;
        }
        if (this.attributeType != null) {
            if (other.attributeType == null) return this.getNormalizedValue().equals(other.getNormalizedValue());
            if (!this.attributeType.equals(other.attributeType)) {
                return false;
            }
        } else if (other.attributeType != null) {
            return this.getNormalizedValue().equals(other.getNormalizedValue());
        }
        if (((String)this.getReference()).equals(other.getReference())) {
            return true;
        }
        if (this.attributeType == null) return this.getNormalizedValue().equals(other.getNormalizedValue());
        try {
            LdapComparator<String> comparator = this.getLdapComparator();
            if (comparator == null) {
                return this.getNormalizedValue().equals(other.getNormalizedValue());
            }
            if (this.isNormalized()) {
                if (comparator.compare(this.getNormalizedValue(), other.getNormalizedValue()) != 0) return false;
                return true;
            }
            Normalizer normalizer = this.attributeType.getEquality().getNormalizer();
            if (comparator.compare(normalizer.normalize(this.get()), normalizer.normalize(other.get())) != 0) return false;
            return true;
        }
        catch (LdapException ne) {
            return false;
        }
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public int length() {
        return this.wrappedValue != null ? ((String)this.wrappedValue).length() : 0;
    }

    @Override
    public byte[] getBytes() {
        return Strings.getBytesUtf8((String)this.wrappedValue);
    }

    @Override
    public String getString() {
        return this.wrappedValue != null ? (String)this.wrappedValue : "";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isHR = in.readBoolean();
        if (!isHR) {
            throw new IOException("The serialized value is not a String value");
        }
        if (in.readBoolean()) {
            this.wrappedValue = in.readUTF();
        }
        this.normalized = in.readBoolean();
        if (this.normalized) {
            if (in.readBoolean()) {
                this.normalizedValue = in.readUTF();
            }
        } else {
            this.normalizedValue = this.wrappedValue;
        }
        this.h = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(true);
        if (this.wrappedValue != null) {
            out.writeBoolean(true);
            out.writeUTF((String)this.wrappedValue);
        } else {
            out.writeBoolean(false);
        }
        if (this.normalized) {
            out.writeBoolean(true);
            if (this.normalizedValue != null) {
                out.writeBoolean(true);
                out.writeUTF((String)this.normalizedValue);
            } else {
                out.writeBoolean(false);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.h);
        out.flush();
    }

    public String toString() {
        return this.wrappedValue == null ? "null" : (String)this.wrappedValue;
    }
}

