/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.EntryAttributeSerializer;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.DnSerializer;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntrySerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(EntrySerializer.class);

    private EntrySerializer() {
    }

    public static void serialize(Entry entry, ObjectOutput out) throws IOException {
        DnSerializer.serialize(entry.getDn(), out);
        int nbAttributes = entry.size();
        out.writeInt(nbAttributes);
        if (nbAttributes > 0) {
            for (EntryAttribute attribute : entry) {
                EntryAttributeSerializer.serialize(attribute, out);
            }
        }
        out.flush();
    }

    public static Entry deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException, LdapInvalidDnException {
        Dn dn = DnSerializer.deserialize(schemaManager, in);
        int nbAttributes = in.readInt();
        EntryAttribute[] attributes = null;
        if (nbAttributes > 0) {
            attributes = new EntryAttribute[nbAttributes];
            for (int i = 0; i < nbAttributes; ++i) {
                EntryAttribute attribute;
                attributes[i] = attribute = EntryAttributeSerializer.deserialize(schemaManager, in);
            }
        }
        DefaultEntry entry = new DefaultEntry(schemaManager, dn, attributes);
        return entry;
    }
}

