/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryAttributeSerializer {
    protected static final Logger LOG = LoggerFactory.getLogger(EntryAttributeSerializer.class);

    private EntryAttributeSerializer() {
    }

    public static void serialize(EntryAttribute attribute, ObjectOutput out) throws IOException {
        attribute.writeExternal(out);
        out.flush();
    }

    public static EntryAttribute deserialize(SchemaManager schemaManager, ObjectInput in) throws IOException {
        DefaultEntryAttribute entryAttribute = new DefaultEntryAttribute();
        try {
            entryAttribute.readExternal(in);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        AttributeType attributeType = null;
        if (schemaManager != null) {
            if (!Strings.isEmpty(entryAttribute.getId())) {
                attributeType = schemaManager.getAttributeType(entryAttribute.getId());
            }
            entryAttribute.setAttributeType(attributeType);
        }
        return entryAttribute;
    }
}

