/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModification
implements Modification {
    private ModificationOperation operation;
    private EntryAttribute attribute;
    private AttributeType attributeType;
    protected static final Logger LOG = LoggerFactory.getLogger(Modification.class);

    public DefaultModification() {
    }

    public DefaultModification(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public DefaultModification(ModificationOperation operation, EntryAttribute attribute) {
        this.operation = operation;
        this.attribute = attribute;
    }

    public DefaultModification(AttributeType attributeType, ModificationOperation operation, EntryAttribute attribute) {
        this.attributeType = attributeType;
        this.operation = operation;
        this.attribute = attribute;
    }

    public DefaultModification(SchemaManager schemaManager, Modification modification) {
        this.operation = modification.getOperation();
        EntryAttribute modAttribute = modification.getAttribute();
        try {
            AttributeType at = modAttribute.getAttributeType();
            if (at == null) {
                at = schemaManager.lookupAttributeTypeRegistry(modAttribute.getId());
            }
            this.attribute = new DefaultEntryAttribute(at, modAttribute);
        }
        catch (LdapException ne) {
            LOG.error(I18n.err(I18n.ERR_04472, modAttribute.getId()));
        }
    }

    public ModificationOperation getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = ModificationOperation.getOperation(operation);
    }

    public void setOperation(ModificationOperation operation) {
        this.operation = operation;
    }

    public EntryAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(EntryAttribute attribute) {
        this.attribute = attribute;
    }

    public void applyAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
        this.attribute.setAttributeType(attributeType);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Modification)) {
            return false;
        }
        Modification otherModification = (Modification)that;
        if (this.operation != otherModification.getOperation()) {
            return false;
        }
        if (this.attribute == null) {
            return otherModification.getAttribute() == null;
        }
        return this.attribute.equals(otherModification.getAttribute());
    }

    public int hashCode() {
        int h = 37;
        h += h * 17 + this.operation.getValue();
        h += h * 17 + this.attribute.hashCode();
        return h;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operation = ModificationOperation.getOperation(in.readInt());
        boolean hasAttribute = in.readBoolean();
        if (hasAttribute) {
            this.attribute = new DefaultEntryAttribute(this.attributeType);
            this.attribute.readExternal(in);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.operation.getValue());
        if (this.attribute != null) {
            out.writeBoolean(true);
            this.attribute.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        out.flush();
    }

    public DefaultModification clone() {
        try {
            DefaultModification clone = (DefaultModification)super.clone();
            clone.attribute = this.attribute.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Modification: ").append((Object)this.operation).append("\n").append(", attribute : ").append(this.attribute);
        return sb.toString();
    }
}

