/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.directory.shared.asn1.util.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.AbstractValue;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntryAttribute
implements EntryAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntryAttribute.class);
    private AttributeType attributeType;
    private Set<Value<?>> values = new LinkedHashSet();
    private String upId;
    private String id;
    private Boolean isHR;
    private volatile int h;

    private Value<String> createStringValue(AttributeType attributeType, String value) {
        StringValue stringValue = null;
        if (attributeType != null) {
            stringValue = new StringValue(attributeType, value);
            try {
                stringValue.normalize();
            }
            catch (LdapException ne) {
                LOG.error(I18n.err(I18n.ERR_04449, value));
                return null;
            }
            if (!stringValue.isValid()) {
                LOG.error(I18n.err(I18n.ERR_04450, value));
                return null;
            }
        } else {
            stringValue = new StringValue(value);
        }
        return stringValue;
    }

    private Value<byte[]> createBinaryValue(AttributeType attributeType, byte[] value) {
        BinaryValue binaryValue = null;
        if (attributeType != null) {
            binaryValue = new BinaryValue(attributeType, value);
            try {
                binaryValue.normalize();
            }
            catch (LdapException ne) {
                LOG.error(I18n.err(I18n.ERR_04449, new Object[]{value}));
                return null;
            }
            if (!binaryValue.isValid()) {
                LOG.error(I18n.err(I18n.ERR_04450, new Object[]{value}));
                return null;
            }
        } else {
            binaryValue = new BinaryValue(value);
        }
        return binaryValue;
    }

    public DefaultEntryAttribute() {
    }

    DefaultEntryAttribute(AttributeType attributeType, String upId, String normId, boolean isHR, int hashCode, Value<?> ... values) {
        this.attributeType = attributeType;
        this.upId = upId;
        this.id = normId;
        this.isHR = isHR;
        this.h = hashCode;
        if (values != null) {
            for (Value<?> value : values) {
                this.values.add(value);
            }
        }
    }

    public DefaultEntryAttribute(AttributeType attributeType) {
        if (attributeType != null) {
            this.setAttributeType(attributeType);
        }
    }

    public DefaultEntryAttribute(String upId) {
        this.setUpId(upId);
    }

    public DefaultEntryAttribute(String upId, AttributeType attributeType) {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04442_NULL_AT_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.setAttributeType(attributeType);
        this.setUpId(upId, attributeType);
    }

    public DefaultEntryAttribute(String upId, Value<?> ... vals) {
        if (vals[0] == null) {
            this.add(new StringValue());
        } else {
            for (Value<?> val : vals) {
                if (!(val instanceof StringValue) && !val.isBinary()) {
                    String message = I18n.err(I18n.ERR_04129, val.getClass().getName());
                    LOG.error(message);
                    throw new IllegalStateException(message);
                }
                this.add(val);
            }
        }
        this.setUpId(upId);
    }

    public DefaultEntryAttribute(AttributeType attributeType, String ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultEntryAttribute(String upId, AttributeType attributeType, String ... vals) {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04442_NULL_AT_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.setAttributeType(attributeType);
        this.add(vals);
        this.setUpId(upId, attributeType);
    }

    public DefaultEntryAttribute(String upId, AttributeType attributeType, Value<?> ... vals) {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04442_NULL_AT_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.setAttributeType(attributeType);
        this.setUpId(upId, attributeType);
        this.add(vals);
    }

    public DefaultEntryAttribute(AttributeType attributeType, Value<?> ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultEntryAttribute(String upId, String ... vals) {
        this.add(vals);
        this.setUpId(upId);
    }

    public DefaultEntryAttribute(String upId, byte[] ... vals) {
        this.add(vals);
        this.setUpId(upId);
    }

    public DefaultEntryAttribute(AttributeType attributeType, byte[] ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultEntryAttribute(String upId, AttributeType attributeType, byte[] ... vals) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04442_NULL_AT_NOT_ALLOWED, new Object[0]));
        }
        this.setAttributeType(attributeType);
        this.add(vals);
        this.setUpId(upId, attributeType);
    }

    public DefaultEntryAttribute(AttributeType attributeType, EntryAttribute attribute) {
        this.attributeType = attributeType;
        this.id = attribute.getId();
        this.upId = attribute.getUpId();
        if (attributeType == null) {
            this.isHR = attribute.isHR();
            for (Value value : attribute) {
                this.add(value.clone());
            }
        } else {
            this.isHR = attributeType.getSyntax().isHumanReadable();
            for (Value clientValue : attribute) {
                AbstractValue serverValue = null;
                if (clientValue instanceof StringValue) {
                    serverValue = this.isHR.booleanValue() ? new StringValue(attributeType, clientValue.getString()) : new BinaryValue(attributeType, clientValue.getBytes());
                } else if (clientValue instanceof BinaryValue) {
                    serverValue = this.isHR != false ? new StringValue(attributeType, clientValue.getString()) : new BinaryValue(attributeType, clientValue.getBytes());
                }
                this.add(serverValue);
            }
        }
    }

    @Override
    public byte[] getBytes() throws LdapInvalidAttributeValueException {
        Value<?> value = this.get();
        if (value.isBinary()) {
            return value.getBytes();
        }
        String message = I18n.err(I18n.ERR_04130, new Object[0]);
        LOG.error(message);
        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    @Override
    public String getString() throws LdapInvalidAttributeValueException {
        Value<?> value = this.get();
        if (value instanceof StringValue) {
            return value.getString();
        }
        if (this.isHR.booleanValue() && value != null) {
            String valueStr = Strings.utf8ToString((byte[])value.getReference());
            return valueStr;
        }
        String message = I18n.err(I18n.ERR_04131, new Object[0]);
        LOG.error(message);
        throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, message);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setHR(boolean isHR) {
        if (this.attributeType == null) {
            this.isHR = isHR;
            this.rehash();
        }
    }

    @Override
    public String getUpId() {
        return this.upId;
    }

    @Override
    public void setUpId(String upId) {
        this.setUpId(upId, this.attributeType);
    }

    private boolean areCompatible(String id, AttributeType attributeType) {
        int optPos = id.indexOf(";");
        String idNoOption = id;
        if (optPos != -1) {
            idNoOption = id.substring(0, optPos);
        }
        for (String name : attributeType.getNames()) {
            if (!name.equalsIgnoreCase(idNoOption)) continue;
            return true;
        }
        return OID.isOID(id) && attributeType.getOid().equals(id);
    }

    @Override
    public void setUpId(String upId, AttributeType attributeType) {
        String trimmed = Strings.trim(upId);
        if (Strings.isEmpty(trimmed) && attributeType == null) {
            throw new IllegalArgumentException("Cannot set a null ID with a null AttributeType");
        }
        String newId = Strings.toLowerCase(trimmed);
        if (attributeType == null) {
            if (this.attributeType == null) {
                this.upId = upId;
                this.id = newId;
                this.rehash();
                return;
            }
            if (this.areCompatible(newId, this.attributeType)) {
                this.upId = upId;
                this.id = this.attributeType.getOid();
                this.rehash();
                return;
            }
            return;
        }
        if (Strings.isEmpty(newId)) {
            this.attributeType = attributeType;
            this.upId = attributeType.getName();
            this.id = attributeType.getOid();
            this.rehash();
            return;
        }
        if (this.areCompatible(newId, attributeType)) {
            this.upId = upId;
            this.id = attributeType.getOid();
            this.attributeType = attributeType;
            this.rehash();
            return;
        }
        throw new IllegalArgumentException("ID '" + this.id + "' and AttributeType '" + attributeType.getName() + "' are not compatible ");
    }

    @Override
    public boolean isHR() {
        return this.isHR != null ? this.isHR : false;
    }

    @Override
    public boolean isValid() throws LdapException {
        if (this.attributeType != null) {
            if (this.attributeType.isSingleValued() && this.values.size() > 1) {
                return false;
            }
            if (this.values.size() == 0) {
                return this.attributeType.getSyntax().getSyntaxChecker().isValidSyntax(null);
            }
        }
        for (Value<?> value : this.values) {
            if (value.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(SyntaxChecker checker) throws LdapException {
        for (Value<?> value : this.values) {
            if (value.isValid(checker)) continue;
            return false;
        }
        return true;
    }

    @Override
    @SuppressWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="Validity of null depends on the checker")
    public int add(Value<?> ... vals) {
        int nbAdded = 0;
        BinaryValue nullBinaryValue = null;
        StringValue nullStringValue = null;
        boolean nullValueAdded = false;
        if (this.attributeType != null) {
            for (Value<?> val : vals) {
                String message;
                AbstractValue nullSV;
                if (this.attributeType.getSyntax().isHumanReadable()) {
                    if (val == null || val.isNull()) {
                        nullSV = new StringValue(this.attributeType, null);
                        if (!this.values.add(nullSV)) continue;
                        ++nbAdded;
                        continue;
                    }
                    if (val instanceof StringValue) {
                        StringValue stringValue = (StringValue)val;
                        if (stringValue.getAttributeType() == null) {
                            stringValue.apply(this.attributeType);
                        }
                        if (!this.values.add(val)) continue;
                        ++nbAdded;
                        continue;
                    }
                    message = I18n.err(I18n.ERR_04451, new Object[0]);
                    LOG.error(message);
                    continue;
                }
                if (val == null) {
                    if (this.attributeType.getSyntax().getSyntaxChecker().isValidSyntax(val)) {
                        nullSV = new BinaryValue(this.attributeType, null);
                        if (!this.values.add(nullSV)) continue;
                        ++nbAdded;
                        continue;
                    }
                    message = I18n.err(I18n.ERR_04452, new Object[0]);
                    LOG.error(message);
                    continue;
                }
                if (val instanceof BinaryValue) {
                    BinaryValue binaryValue = (BinaryValue)val;
                    if (binaryValue.getAttributeType() == null) {
                        binaryValue = new BinaryValue(this.attributeType, val.getBytes());
                    }
                    if (!this.values.add(binaryValue)) continue;
                    ++nbAdded;
                    continue;
                }
                message = I18n.err(I18n.ERR_04452, new Object[0]);
                LOG.error(message);
            }
        } else {
            for (Value<?> val : vals) {
                if (val == null) {
                    if (this.isHR == null) {
                        nullBinaryValue = new BinaryValue((byte[])null);
                        nullStringValue = new StringValue((String)null);
                        this.values.add(nullBinaryValue);
                        this.values.add(nullStringValue);
                        nullValueAdded = true;
                        ++nbAdded;
                        continue;
                    }
                    if (!this.isHR.booleanValue()) {
                        nullBinaryValue = new BinaryValue((byte[])null);
                        if (this.values.contains(nullBinaryValue)) continue;
                        this.values.add(nullBinaryValue);
                        ++nbAdded;
                        continue;
                    }
                    nullStringValue = new StringValue((String)null);
                    if (this.values.contains(nullStringValue)) continue;
                    this.values.add(nullStringValue);
                    continue;
                }
                if (val instanceof StringValue) {
                    if (this.isHR == null) {
                        this.isHR = true;
                        this.values.add(val);
                        ++nbAdded;
                        continue;
                    }
                    if (!this.isHR.booleanValue()) {
                        BinaryValue bv = new BinaryValue(val.getBytes());
                        if (this.contains(bv)) continue;
                        this.values.add(bv);
                        ++nbAdded;
                        continue;
                    }
                    if (this.contains(val)) continue;
                    this.values.add(val);
                    ++nbAdded;
                    continue;
                }
                if (this.isHR == null) {
                    this.isHR = false;
                    this.values.add(val);
                    ++nbAdded;
                    continue;
                }
                if (!this.isHR.booleanValue()) {
                    if (this.contains(val)) continue;
                    this.values.add(val);
                    ++nbAdded;
                    continue;
                }
                StringValue sv = new StringValue(val.getString());
                if (this.contains(sv)) continue;
                this.values.add(sv);
                ++nbAdded;
            }
        }
        if (nullValueAdded) {
            if (this.isHR.booleanValue()) {
                this.values.remove(nullBinaryValue);
            } else {
                this.values.remove(nullStringValue);
            }
        }
        return nbAdded;
    }

    @Override
    public int add(String ... vals) {
        int nbAdded = 0;
        if (this.isHR == null) {
            this.isHR = true;
        }
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (String val : vals) {
                    Value<String> value = this.createStringValue(this.attributeType, val);
                    if (value == null) {
                        LOG.error(I18n.err(I18n.ERR_04449, val));
                        continue;
                    }
                    if (this.add(value) == 1) {
                        ++nbAdded;
                        continue;
                    }
                    LOG.error(I18n.err(I18n.ERR_04486_VALUE_ALREADY_EXISTS, val, this.upId));
                }
            } else {
                for (String val : vals) {
                    Value<byte[]> value;
                    byte[] valBytes = null;
                    if (val != null) {
                        valBytes = Strings.getBytesUtf8(val);
                    }
                    if ((value = this.createBinaryValue(this.attributeType, valBytes)) == null) {
                        LOG.error(I18n.err(I18n.ERR_04449, val));
                        continue;
                    }
                    if (this.add(value) != 1) continue;
                    ++nbAdded;
                }
            }
        } else if (this.isHR.booleanValue()) {
            for (String val : vals) {
                Value<String> value = this.createStringValue(this.attributeType, val);
                if (value == null) {
                    LOG.error(I18n.err(I18n.ERR_04449, val));
                    continue;
                }
                if (this.add(value) == 1) {
                    ++nbAdded;
                    continue;
                }
                LOG.error(I18n.err(I18n.ERR_04486_VALUE_ALREADY_EXISTS, val, this.upId));
            }
        } else {
            for (String val : vals) {
                Value<byte[]> value;
                byte[] valBytes = null;
                if (val != null) {
                    valBytes = Strings.getBytesUtf8(val);
                }
                if ((value = this.createBinaryValue(this.attributeType, valBytes)) == null) {
                    LOG.error(I18n.err(I18n.ERR_04449, val));
                    continue;
                }
                if (this.add(value) != 1) continue;
                ++nbAdded;
            }
        }
        return nbAdded;
    }

    @Override
    public int add(byte[] ... vals) {
        int nbAdded = 0;
        if (this.isHR == null) {
            this.isHR = false;
        }
        if (!this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                BinaryValue value = null;
                if (this.attributeType == null) {
                    value = new BinaryValue(val);
                } else {
                    value = new BinaryValue(this.attributeType, val);
                    try {
                        value.normalize();
                    }
                    catch (LdapException ne) {
                        LOG.error(I18n.err(I18n.ERR_04449, Strings.dumpBytes(val)));
                        return 0;
                    }
                }
                if (this.add(value) != 0) {
                    ++nbAdded;
                    continue;
                }
                LOG.error(I18n.err(I18n.ERR_04486_VALUE_ALREADY_EXISTS, Strings.dumpBytes(val), this.upId));
            }
        } else {
            LOG.info(I18n.err(I18n.ERR_04451, new Object[0]));
            return 0;
        }
        return nbAdded;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean contains(Value<?> ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (Value<?> val : vals) {
                    byte[] binaryVal;
                    if (!(val instanceof StringValue ? !this.values.contains(val) : !this.values.contains(new StringValue(Strings.utf8ToString(binaryVal = val.getBytes()))))) continue;
                    return false;
                }
            } else {
                for (Value<?> val : vals) {
                    String stringVal;
                    if (!(val.isBinary() ? !this.values.contains(val) : !this.values.contains(new BinaryValue(Strings.getBytesUtf8(stringVal = val.getString()))))) continue;
                    return false;
                }
            }
        } else if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof StringValue) {
                    StringValue stringValue = (StringValue)val;
                    if (stringValue.getAttributeType() == null) {
                        stringValue.apply(this.attributeType);
                    }
                    if (this.values.contains(val)) continue;
                    return false;
                }
                return false;
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof BinaryValue) {
                    if (this.values.contains(val)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(String ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (String val : vals) {
                    if (this.contains(new StringValue(val))) continue;
                    return false;
                }
            } else {
                for (String val : vals) {
                    byte[] binaryVal = Strings.getBytesUtf8(val);
                    if (this.contains(new BinaryValue(binaryVal))) continue;
                    return false;
                }
            }
        } else {
            if (this.isHR.booleanValue()) {
                for (String val : vals) {
                    StringValue value = new StringValue(this.attributeType, val);
                    if (this.values.contains(value)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(byte[] ... vals) {
        if (this.isHR == null) {
            return false;
        }
        if (this.attributeType == null) {
            if (!this.isHR.booleanValue()) {
                for (byte[] val : vals) {
                    if (this.contains(new BinaryValue(val))) continue;
                    return false;
                }
            } else {
                for (byte[] val : vals) {
                    String stringVal = Strings.utf8ToString(val);
                    if (this.contains(new StringValue(stringVal))) continue;
                    return false;
                }
            }
        } else {
            if (!this.isHR.booleanValue()) {
                for (byte[] val : vals) {
                    BinaryValue value = new BinaryValue(this.attributeType, val);
                    try {
                        value.normalize();
                    }
                    catch (LdapException ne) {
                        return false;
                    }
                    if (this.values.contains(value)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean contains(Object ... vals) {
        boolean isHR = true;
        boolean seen = false;
        for (Object val : vals) {
            if (val instanceof String) {
                if (!seen) {
                    isHR = true;
                    seen = true;
                }
                if (isHR) {
                    if (this.contains((String)val)) continue;
                    return false;
                }
                return false;
            }
            if (!seen) {
                isHR = false;
                seen = true;
            }
            if (!isHR) {
                if (this.contains(new byte[][]{(byte[])val})) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public Value<?> get() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.iterator().next();
    }

    @Override
    public Value<?> get(int i) {
        if (this.values.size() < i) {
            return null;
        }
        int n = 0;
        for (Value<?> value : this.values) {
            if (n == i) {
                return value;
            }
            ++n;
        }
        return null;
    }

    @Override
    public Iterator<Value<?>> getAll() {
        return this.iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean remove(Value<?> ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (Value<?> val : vals) {
                    if (val instanceof StringValue) {
                        removed &= this.values.remove(val);
                        continue;
                    }
                    byte[] binaryVal = val.getBytes();
                    removed &= this.values.remove(new StringValue(Strings.utf8ToString(binaryVal)));
                }
            } else {
                for (Value<?> val : vals) {
                    removed &= this.values.remove(val);
                }
            }
        } else if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof StringValue) {
                    StringValue stringValue = (StringValue)val;
                    if (stringValue.getAttributeType() == null) {
                        stringValue.apply(this.attributeType);
                    }
                    removed &= this.values.remove(stringValue);
                    continue;
                }
                removed = false;
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof BinaryValue) {
                    BinaryValue binaryValue = (BinaryValue)val;
                    if (binaryValue.getAttributeType() == null) {
                        binaryValue.apply(this.attributeType);
                    }
                    removed &= this.values.remove(binaryValue);
                    continue;
                }
                removed = false;
            }
        }
        return removed;
    }

    @Override
    public boolean remove(byte[] ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (this.attributeType == null) {
            if (!this.isHR.booleanValue()) {
                for (byte[] val : vals) {
                    BinaryValue value = new BinaryValue(val);
                    removed &= this.values.remove(value);
                }
            } else {
                for (byte[] val : vals) {
                    StringValue value = new StringValue(Strings.utf8ToString(val));
                    removed &= this.values.remove(value);
                }
            }
        } else if (!this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                BinaryValue value = new BinaryValue(this.attributeType, val);
                removed &= this.values.remove(value);
            }
        } else {
            removed = false;
        }
        return removed;
    }

    @Override
    public boolean remove(String ... vals) {
        if (this.isHR == null || this.values.size() == 0) {
            return false;
        }
        boolean removed = true;
        if (this.attributeType == null) {
            if (this.isHR.booleanValue()) {
                for (String val : vals) {
                    StringValue value = new StringValue(val);
                    removed &= this.values.remove(value);
                }
            } else {
                for (String val : vals) {
                    BinaryValue value = new BinaryValue(Strings.getBytesUtf8(val));
                    removed &= this.values.remove(value);
                }
            }
        } else if (this.isHR.booleanValue()) {
            for (String val : vals) {
                StringValue value = new StringValue(this.attributeType, val);
                removed &= this.values.remove(value);
            }
        } else {
            removed = false;
        }
        return removed;
    }

    @Override
    public Iterator<Value<?>> iterator() {
        return this.values.iterator();
    }

    @Override
    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public void setAttributeType(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException("The AttributeType parameter should not be null");
        }
        this.attributeType = attributeType;
        this.id = attributeType.getOid();
        if (Strings.isEmpty(this.upId)) {
            this.upId = attributeType.getName();
        } else if (!this.areCompatible(this.upId, attributeType)) {
            this.upId = attributeType.getName();
        }
        if (this.values != null) {
            for (Value<?> value : this.values) {
                value.apply(attributeType);
            }
        }
        this.isHR = attributeType.getSyntax().isHumanReadable();
        this.rehash();
    }

    @Override
    public boolean instanceOf(String attributeId) throws LdapInvalidAttributeValueException {
        String trimmedId = Strings.trim(attributeId);
        if (Strings.isEmpty(trimmedId)) {
            return false;
        }
        String normId = Strings.lowerCaseAscii(trimmedId);
        for (String name : this.attributeType.getNames()) {
            if (!normId.equalsIgnoreCase(name)) continue;
            return true;
        }
        return normId.equalsIgnoreCase(this.attributeType.getOid());
    }

    private void rehash() {
        this.h = 37;
        if (this.isHR != null) {
            this.h = this.h * 17 + this.isHR.hashCode();
        }
        if (this.id != null) {
            this.h = this.h * 17 + this.id.hashCode();
        }
        if (this.attributeType != null) {
            this.h = this.h * 17 + this.attributeType.hashCode();
        }
    }

    public int hashCode() {
        if (this.h == 0) {
            this.rehash();
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntryAttribute)) {
            return false;
        }
        EntryAttribute other = (EntryAttribute)obj;
        if (this.id == null) {
            if (other.getId() != null) {
                return false;
            }
        } else {
            if (other.getId() == null) {
                return false;
            }
            if (this.attributeType != null ? !this.attributeType.equals(other.getAttributeType()) : !this.id.equals(other.getId())) {
                return false;
            }
        }
        if (this.isHR() != other.isHR()) {
            return false;
        }
        if (this.values.size() != other.size()) {
            return false;
        }
        for (Value<?> val : this.values) {
            if (other.contains(val)) continue;
            return false;
        }
        if (this.attributeType == null) {
            return other.getAttributeType() == null;
        }
        return this.attributeType.equals(other.getAttributeType());
    }

    @Override
    public EntryAttribute clone() {
        try {
            DefaultEntryAttribute attribute = (DefaultEntryAttribute)super.clone();
            attribute.setUpId(this.upId);
            attribute.values = new LinkedHashSet(this.values.size());
            for (Value<?> value : this.values) {
                attribute.values.add(value.clone());
            }
            return attribute;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.values != null && this.values.size() != 0) {
            for (Value<?> value : this.values) {
                sb.append("    ").append(this.upId).append(": ");
                if (value.isNull()) {
                    sb.append("''");
                } else {
                    sb.append(value);
                }
                sb.append('\n');
            }
        } else {
            sb.append("    ").append(this.upId).append(": (null)\n");
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.upId);
        if (this.isHR != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.isHR);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.size());
        if (this.size() > 0) {
            for (Value<?> value : this.values) {
                value.writeExternal(out);
            }
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int nbValues;
        this.upId = in.readUTF();
        this.setUpId(this.upId);
        if (in.readBoolean()) {
            this.isHR = in.readBoolean();
        }
        if ((nbValues = in.readInt()) > 0) {
            for (int i = 0; i < nbValues; ++i) {
                AbstractValue value = null;
                value = this.isHR != false ? new StringValue(this.attributeType) : new BinaryValue(this.attributeType);
                value.readExternal(in);
                this.values.add(value);
            }
        }
    }
}

