/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.DnSerializer;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.name.RdnSerializer;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.Unicode;
import org.apache.directory.shared.util.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntry
implements Entry {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntry.class);
    private Dn dn;
    private Map<String, EntryAttribute> attributes;
    private static AttributeType objectClassAttributeType;
    private SchemaManager schemaManager;
    private volatile int h;
    private static final Object MUTEX;

    public DefaultEntry() {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.schemaManager = null;
        this.dn = Dn.EMPTY_DN;
    }

    public DefaultEntry(SchemaManager schemaManager) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.schemaManager = schemaManager;
        this.dn = Dn.EMPTY_DN;
        this.initObjectClassAT();
    }

    public DefaultEntry(Dn dn) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.dn = dn;
    }

    public DefaultEntry(SchemaManager schemaManager, Dn dn) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.schemaManager = schemaManager;
        if (dn == null) {
            this.dn = Dn.EMPTY_DN;
        } else {
            this.dn = dn;
            this.normalizeDN(this.dn);
        }
        this.initObjectClassAT();
    }

    public DefaultEntry(Dn dn, String ... upIds) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.dn = dn;
        for (String upId : upIds) {
            this.set(upId);
        }
    }

    public DefaultEntry(SchemaManager schemaManager, Entry entry) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.schemaManager = schemaManager;
        this.initObjectClassAT();
        if (entry.getDn() != null) {
            this.dn = entry.getDn();
            this.normalizeDN(this.dn);
        } else {
            this.dn = Dn.EMPTY_DN;
        }
        this.attributes = new HashMap<String, EntryAttribute>(entry.size());
        for (EntryAttribute attribute : entry) {
            try {
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType == null) {
                    attributeType = schemaManager.lookupAttributeTypeRegistry(attribute.getId());
                }
                DefaultEntryAttribute serverAttribute = new DefaultEntryAttribute(attributeType, attribute);
                this.add(serverAttribute);
            }
            catch (LdapException ne) {
                LOG.warn("The attribute '" + attribute.getId() + "' cannot be stored");
            }
        }
    }

    public DefaultEntry(SchemaManager schemaManager, Dn dn, String ... upIds) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.schemaManager = schemaManager;
        if (dn == null) {
            this.dn = Dn.EMPTY_DN;
        } else {
            this.dn = dn;
            this.normalizeDN(this.dn);
        }
        this.initObjectClassAT();
        this.set(upIds);
    }

    public DefaultEntry(Dn dn, EntryAttribute ... attributes) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.dn = dn;
        for (EntryAttribute attribute : attributes) {
            if (attribute == null) continue;
            this.attributes.put(attribute.getId(), attribute);
        }
    }

    public DefaultEntry(SchemaManager schemaManager, Dn dn, EntryAttribute ... attributes) {
        block8: {
            block7: {
                this.attributes = new HashMap<String, EntryAttribute>();
                this.schemaManager = schemaManager;
                if (dn == null) {
                    this.dn = Dn.EMPTY_DN;
                } else {
                    this.dn = dn;
                    this.normalizeDN(this.dn);
                }
                if (schemaManager != null) break block7;
                if (attributes == null) break block8;
                for (EntryAttribute attribute : attributes) {
                    if (attribute == null) continue;
                    this.attributes.put(attribute.getId(), attribute);
                }
                break block8;
            }
            this.initObjectClassAT();
            if (attributes != null) {
                for (EntryAttribute attribute : attributes) {
                    try {
                        this.put(attribute);
                    }
                    catch (LdapException ne) {
                        LOG.warn("The ServerAttribute '{}' does not exist. It has been discarded", (Object)attribute);
                    }
                }
            }
        }
    }

    public DefaultEntry(SchemaManager schemaManager, Dn dn, AttributeType ... attributeTypes) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.schemaManager = schemaManager;
        if (dn == null) {
            this.dn = Dn.EMPTY_DN;
        } else {
            this.dn = dn;
            this.normalizeDN(this.dn);
        }
        this.initObjectClassAT();
        this.set(attributeTypes);
    }

    public DefaultEntry(SchemaManager schemaManager, Dn dn, AttributeType attributeType, String upId) {
        this.attributes = new HashMap<String, EntryAttribute>();
        this.schemaManager = schemaManager;
        if (dn == null) {
            this.dn = Dn.EMPTY_DN;
        } else {
            this.dn = dn;
            this.normalizeDN(dn);
        }
        this.initObjectClassAT();
        try {
            this.put(upId, attributeType, new String[]{null});
        }
        catch (LdapException ne) {
            LOG.error(I18n.err(I18n.ERR_04459, upId, ne.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initObjectClassAT() {
        block5: {
            try {
                if (objectClassAttributeType != null) break block5;
                Object object = MUTEX;
                synchronized (object) {
                    objectClassAttributeType = this.schemaManager.lookupAttributeTypeRegistry("objectClass");
                }
            }
            catch (LdapException ldapException) {
                // empty catch block
            }
        }
    }

    private String getId(String upId) {
        String id = Strings.trim(Strings.toLowerCase(upId));
        if (id == null || id.length() == 0) {
            String message = I18n.err(I18n.ERR_04133, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        return id;
    }

    private static String getUpId(String upId, AttributeType attributeType) {
        String normUpId = Strings.trim(upId);
        if (attributeType == null) {
            if (Strings.isEmpty(normUpId)) {
                String message = I18n.err(I18n.ERR_04458, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (Strings.isEmpty(normUpId) && Strings.isEmpty(upId = attributeType.getName())) {
            upId = attributeType.getOid();
        }
        return upId;
    }

    protected void createAttribute(String upId, AttributeType attributeType, byte[] ... values) {
        DefaultEntryAttribute attribute = new DefaultEntryAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType.getOid(), attribute);
    }

    protected void createAttribute(String upId, AttributeType attributeType, String ... values) {
        DefaultEntryAttribute attribute = new DefaultEntryAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType.getOid(), attribute);
    }

    protected void createAttribute(String upId, AttributeType attributeType, Value<?> ... values) {
        DefaultEntryAttribute attribute = new DefaultEntryAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType.getOid(), attribute);
    }

    protected AttributeType getAttributeType(String upId) throws LdapException {
        if (Strings.isEmpty(Strings.trim(upId))) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        return this.schemaManager.lookupAttributeTypeRegistry(upId);
    }

    @Override
    public void add(AttributeType attributeType, byte[] ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (values == null || values.length == 0) {
            String message = I18n.err(I18n.ERR_04478_NO_VALUE_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (attributeType.equals(objectClassAttributeType)) {
            String message = I18n.err(I18n.ERR_04461, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(AttributeType attributeType, String ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(AttributeType attributeType, Value<?> ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        if (attributeType.equals(objectClassAttributeType)) {
            String message = I18n.err(I18n.ERR_04461, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        upId = DefaultEntry.getUpId(upId, attributeType);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        upId = DefaultEntry.getUpId(upId, attributeType);
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, String ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        upId = DefaultEntry.getUpId(upId, attributeType);
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId, attributeType);
        } else {
            this.createAttribute(upId, attributeType, values);
        }
    }

    @Override
    public void add(EntryAttribute ... attributes) throws LdapException {
        for (EntryAttribute attribute : attributes) {
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType != null) {
                String oid = attributeType.getOid();
                if (this.attributes.containsKey(oid)) {
                    EntryAttribute existingAttribute = this.attributes.get(oid);
                    for (Value value : attribute) {
                        existingAttribute.add(value);
                    }
                    existingAttribute.setUpId(attribute.getUpId());
                    continue;
                }
                this.attributes.put(oid, attribute);
                continue;
            }
            if (this.contains(attribute)) {
                EntryAttribute existingAttribute = this.get(attribute.getId());
                for (Value value : attribute) {
                    existingAttribute.add(value);
                }
                continue;
            }
            this.attributes.put(attribute.getId(), attribute);
        }
    }

    @Override
    public void add(String upId, byte[] ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            this.add(upId, this.schemaManager.lookupAttributeTypeRegistry(id), values);
        } else {
            EntryAttribute attribute = this.attributes.get(id);
            if (attribute != null) {
                attribute.add(values);
                attribute.setUpId(upId);
            } else {
                this.attributes.put(id, new DefaultEntryAttribute(upId, values));
            }
        }
    }

    @Override
    public void add(String upId, String ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            this.add(upId, this.schemaManager.lookupAttributeTypeRegistry(upId), values);
        } else {
            EntryAttribute attribute = this.attributes.get(id);
            if (attribute != null) {
                attribute.add(values);
                attribute.setUpId(upId);
            } else {
                this.attributes.put(id, new DefaultEntryAttribute(upId, values));
            }
        }
    }

    @Override
    public void add(String upId, Value<?> ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            this.add(upId, this.schemaManager.lookupAttributeTypeRegistry(upId), values);
        } else {
            EntryAttribute attribute = this.attributes.get(id);
            if (attribute != null) {
                attribute.add(values);
                attribute.setUpId(upId);
            } else {
                this.attributes.put(id, new DefaultEntryAttribute(upId, values));
            }
        }
    }

    @Override
    public Entry clone() {
        try {
            DefaultEntry clone = (DefaultEntry)super.clone();
            if (clone == null) {
                return null;
            }
            clone.dn = this.dn;
            clone.attributes = (Map)((HashMap)this.attributes).clone();
            clone.attributes.clear();
            if (this.schemaManager != null) {
                for (EntryAttribute attribute : this.attributes.values()) {
                    String oid = attribute.getAttributeType().getOid();
                    clone.attributes.put(oid, attribute.clone());
                }
            } else {
                for (EntryAttribute attribute : this.attributes.values()) {
                    clone.attributes.put(attribute.getId(), attribute.clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public boolean contains(EntryAttribute ... attributes) throws LdapException {
        if (this.schemaManager == null) {
            for (EntryAttribute attribute : attributes) {
                if (attribute == null) {
                    return this.attributes.size() == 0;
                }
                if (this.attributes.containsKey(attribute.getId())) continue;
                return false;
            }
        } else {
            for (EntryAttribute entryAttribute : attributes) {
                if (entryAttribute == null) {
                    return this.attributes.size() == 0;
                }
                AttributeType attributeType = entryAttribute.getAttributeType();
                if (entryAttribute != null && this.attributes.containsKey(attributeType.getOid())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(String upId) throws LdapException {
        if (Strings.isEmpty(upId)) {
            return false;
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            try {
                return this.containsAttribute(this.schemaManager.lookupAttributeTypeRegistry(id));
            }
            catch (LdapException le) {
                return false;
            }
        }
        return this.attributes.containsKey(id);
    }

    @Override
    public boolean containsAttribute(String ... attributes) {
        if (this.schemaManager == null) {
            for (String attribute : attributes) {
                String id = this.getId(attribute);
                if (this.attributes.containsKey(id)) continue;
                return false;
            }
            return true;
        }
        for (String attribute : attributes) {
            try {
                if (this.containsAttribute(this.schemaManager.lookupAttributeTypeRegistry(attribute))) continue;
                return false;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAttribute(AttributeType attributeType) {
        if (attributeType == null) {
            return false;
        }
        return this.attributes.containsKey(attributeType.getOid());
    }

    @Override
    public boolean contains(AttributeType attributeType, byte[] ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(AttributeType attributeType, String ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(AttributeType attributeType, Value<?> ... values) {
        if (attributeType == null) {
            return false;
        }
        EntryAttribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(String upId, byte[] ... values) {
        if (Strings.isEmpty(upId)) {
            return false;
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            try {
                return this.contains(this.schemaManager.lookupAttributeTypeRegistry(id), values);
            }
            catch (LdapException le) {
                return false;
            }
        }
        EntryAttribute attribute = this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public boolean contains(String upId, String ... values) {
        if (Strings.isEmpty(upId)) {
            return false;
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            try {
                return this.contains(this.schemaManager.lookupAttributeTypeRegistry(id), values);
            }
            catch (LdapException le) {
                return false;
            }
        }
        EntryAttribute attribute = this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public boolean contains(String upId, Value<?> ... values) {
        if (Strings.isEmpty(upId)) {
            return false;
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            try {
                return this.contains(this.schemaManager.lookupAttributeTypeRegistry(id), values);
            }
            catch (LdapException le) {
                return false;
            }
        }
        EntryAttribute attribute = this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public EntryAttribute get(String alias) {
        try {
            String id = this.getId(alias);
            if (this.schemaManager != null) {
                try {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(id);
                    return this.attributes.get(attributeType.getOid());
                }
                catch (LdapException ne) {
                    String message = ne.getLocalizedMessage();
                    LOG.error(message);
                    return null;
                }
            }
            return this.attributes.get(id);
        }
        catch (IllegalArgumentException iea) {
            LOG.error(I18n.err(I18n.ERR_04134, alias));
            return null;
        }
    }

    @Override
    public EntryAttribute get(AttributeType attributeType) {
        if (attributeType != null) {
            return this.attributes.get(attributeType.getOid());
        }
        return null;
    }

    @Override
    public Set<AttributeType> getAttributeTypes() {
        HashSet<AttributeType> attributeTypes = new HashSet<AttributeType>();
        for (EntryAttribute attribute : this.attributes.values()) {
            if (attribute.getAttributeType() == null) continue;
            attributeTypes.add(attribute.getAttributeType());
        }
        return attributeTypes;
    }

    @Override
    public EntryAttribute put(String upId, byte[] ... values) {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            DefaultEntryAttribute clientAttribute = new DefaultEntryAttribute(upId, values);
            return this.attributes.put(id, clientAttribute);
        }
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (LdapException ne) {
            String message = I18n.err(I18n.ERR_04464, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public EntryAttribute put(String upId, String ... values) {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            DefaultEntryAttribute clientAttribute = new DefaultEntryAttribute(upId, values);
            return this.attributes.put(id, clientAttribute);
        }
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (LdapException ne) {
            String message = I18n.err(I18n.ERR_04464, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public EntryAttribute put(String upId, Value<?> ... values) {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            DefaultEntryAttribute clientAttribute = new DefaultEntryAttribute(upId, values);
            return this.attributes.put(id, clientAttribute);
        }
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (LdapException ne) {
            String message = I18n.err(I18n.ERR_04464, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public List<EntryAttribute> set(String ... upIds) {
        if (upIds == null || upIds.length == 0) {
            String message = I18n.err(I18n.ERR_04135, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>();
        boolean added = false;
        if (this.schemaManager == null) {
            for (String upId : upIds) {
                if (upId == null) {
                    String message = I18n.err(I18n.ERR_04135, new Object[0]);
                    LOG.info(message);
                    throw new IllegalArgumentException(message);
                }
                String id = this.getId(upId);
                if (this.attributes.containsKey(id)) {
                    removed.add(this.attributes.remove(id));
                }
                DefaultEntryAttribute newAttribute = new DefaultEntryAttribute(upId);
                this.attributes.put(id, newAttribute);
                added = true;
            }
        } else {
            for (String upId : upIds) {
                if (upId == null) {
                    String message = I18n.err(I18n.ERR_04135, new Object[0]);
                    LOG.info(message);
                    throw new IllegalArgumentException(message);
                }
                AttributeType attributeType = null;
                try {
                    attributeType = this.getAttributeType(upId);
                }
                catch (LdapException ne) {
                    LOG.warn("Trying to add a bad attribute type '{}', error : ", (Object)upId, (Object)ne.getLocalizedMessage());
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    LOG.warn("Trying to add a bad attribute type '{}', error : ", (Object)upId, (Object)iae.getLocalizedMessage());
                    continue;
                }
                String oid = attributeType.getOid();
                if (this.attributes.containsKey(oid)) {
                    removed.add(this.attributes.get(oid));
                }
                this.attributes.put(oid, new DefaultEntryAttribute(upId, attributeType));
                added = true;
            }
        }
        if (!added || removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public List<EntryAttribute> set(AttributeType ... attributeTypes) {
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>();
        for (AttributeType attributeType : attributeTypes) {
            if (attributeType == null) {
                String message = I18n.err(I18n.ERR_04467, new Object[0]);
                LOG.error(message);
                continue;
            }
            EntryAttribute attribute = this.attributes.put(attributeType.getOid(), new DefaultEntryAttribute(attributeType));
            if (attribute == null) continue;
            removed.add(attribute);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public List<EntryAttribute> put(EntryAttribute ... attributes) throws LdapException {
        ArrayList<EntryAttribute> previous = new ArrayList<EntryAttribute>();
        if (this.schemaManager == null) {
            for (EntryAttribute attribute : attributes) {
                String id = attribute.getId();
                if (this.contains(id)) {
                    previous.add(this.get(id));
                    this.attributes.remove(id);
                }
                this.attributes.put(id, attribute);
            }
        } else {
            for (EntryAttribute attribute : attributes) {
                EntryAttribute removed;
                if (attribute == null) {
                    String message = I18n.err(I18n.ERR_04462, new Object[0]);
                    LOG.error(message);
                    throw new IllegalArgumentException(message);
                }
                if (attribute.getAttributeType() == null) {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(attribute.getId());
                    attribute.setAttributeType(attributeType);
                }
                if ((removed = this.attributes.put(attribute.getAttributeType().getOid(), attribute)) == null) continue;
                previous.add(removed);
            }
        }
        return previous;
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.put(null, attributeType, values);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, String ... values) throws LdapException {
        return this.put(null, attributeType, values);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.put(null, attributeType, values);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        if (attributeType == null) {
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (Exception e) {
                String message = I18n.err(I18n.ERR_04477_NO_VALID_AT_FOR_THIS_ID, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (!Strings.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_04463, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultEntry.getUpId(upId, attributeType);
        }
        if (attributeType.equals(objectClassAttributeType)) {
            String message = I18n.err(I18n.ERR_04461, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        DefaultEntryAttribute attribute = new DefaultEntryAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType.getOid(), attribute);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, String ... values) throws LdapException {
        if (attributeType == null) {
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (Exception e) {
                String message = I18n.err(I18n.ERR_04477_NO_VALID_AT_FOR_THIS_ID, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (!Strings.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_04463, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultEntry.getUpId(upId, attributeType);
        }
        DefaultEntryAttribute attribute = new DefaultEntryAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType.getOid(), attribute);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        if (attributeType == null) {
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (Exception e) {
                String message = I18n.err(I18n.ERR_04477_NO_VALID_AT_FOR_THIS_ID, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (!Strings.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_04463, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = DefaultEntry.getUpId(upId, attributeType);
        }
        DefaultEntryAttribute attribute = new DefaultEntryAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType.getOid(), attribute);
    }

    @Override
    public List<EntryAttribute> remove(EntryAttribute ... attributes) throws LdapException {
        ArrayList<EntryAttribute> removedAttributes = new ArrayList<EntryAttribute>();
        if (this.schemaManager == null) {
            for (EntryAttribute attribute : attributes) {
                if (!this.contains(attribute.getId())) continue;
                this.attributes.remove(attribute.getId());
                removedAttributes.add(attribute);
            }
        } else {
            for (EntryAttribute attribute : attributes) {
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType == null) {
                    String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
                    LOG.error(message);
                    throw new IllegalArgumentException(message);
                }
                if (!this.attributes.containsKey(attributeType.getOid())) continue;
                this.attributes.remove(attributeType.getOid());
                removedAttributes.add(attribute);
            }
        }
        return removedAttributes;
    }

    @Override
    public boolean remove(AttributeType attributeType, byte[] ... values) throws LdapException {
        if (attributeType == null) {
            return false;
        }
        try {
            EntryAttribute attribute = this.attributes.get(attributeType.getOid());
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType.getOid());
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04465, attributeType));
            return false;
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, String ... values) throws LdapException {
        if (attributeType == null) {
            return false;
        }
        try {
            EntryAttribute attribute = this.attributes.get(attributeType.getOid());
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType.getOid());
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04465, attributeType));
            return false;
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, Value<?> ... values) throws LdapException {
        if (attributeType == null) {
            return false;
        }
        try {
            EntryAttribute attribute = this.attributes.get(attributeType.getOid());
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType.getOid());
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04465, attributeType));
            return false;
        }
    }

    @Override
    public List<EntryAttribute> removeAttributes(AttributeType ... attributes) {
        if (attributes == null || attributes.length == 0 || this.schemaManager == null) {
            return null;
        }
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>(attributes.length);
        for (AttributeType attributeType : attributes) {
            EntryAttribute attr;
            if (attributeType == null || (attr = this.attributes.remove(attributeType.getOid())) == null) continue;
            removed.add(attr);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public List<EntryAttribute> removeAttributes(String ... attributes) {
        if (attributes.length == 0) {
            return null;
        }
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>(attributes.length);
        if (this.schemaManager == null) {
            for (String attribute : attributes) {
                EntryAttribute attr = this.get(attribute);
                if (attr != null) {
                    removed.add(this.attributes.remove(attr.getId()));
                    continue;
                }
                String message = I18n.err(I18n.ERR_04137, attribute);
                LOG.warn(message);
            }
        } else {
            for (String attribute : attributes) {
                AttributeType attributeType = null;
                try {
                    attributeType = this.schemaManager.lookupAttributeTypeRegistry(attribute);
                }
                catch (LdapException ne) {
                    String message = "The attribute '" + attribute + "' does not exist in the entry";
                    LOG.warn(message);
                    continue;
                }
                EntryAttribute attr = this.attributes.remove(attributeType.getOid());
                if (attr == null) continue;
                removed.add(attr);
            }
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public boolean remove(String upId, byte[] ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.info(message);
            return false;
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            EntryAttribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (LdapException ne) {
            LOG.error(I18n.err(I18n.ERR_04465, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04466, upId));
            return false;
        }
    }

    @Override
    public boolean remove(String upId, String ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.info(message);
            return false;
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            EntryAttribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (LdapException ne) {
            LOG.error(I18n.err(I18n.ERR_04465, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04466, upId));
            return false;
        }
    }

    @Override
    public boolean remove(String upId, Value<?> ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.info(message);
            return false;
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            EntryAttribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (LdapException ne) {
            LOG.error(I18n.err(I18n.ERR_04465, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04466, upId));
            return false;
        }
    }

    @Override
    public Dn getDn() {
        return this.dn;
    }

    @Override
    public void setDn(Dn dn) {
        this.dn = dn;
        this.rehash();
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public Iterator<EntryAttribute> iterator() {
        return Collections.unmodifiableMap(this.attributes).values().iterator();
    }

    @Override
    public boolean isValid() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isValid(EntryAttribute objectClass) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isValid(String objectClass) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.dn == null) {
            DnSerializer.serialize(Dn.EMPTY_DN, out);
        } else {
            DnSerializer.serialize(this.dn, out);
        }
        out.writeInt(this.attributes.size());
        for (EntryAttribute attribute : this.attributes.values()) {
            out.writeObject(attribute);
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.dn = DnSerializer.deserialize(this.schemaManager, in);
        }
        catch (LdapInvalidDnException lide) {
            throw new IOException(lide.getMessage());
        }
        int nbAttributes = in.readInt();
        for (int i = 0; i < nbAttributes; ++i) {
            DefaultEntryAttribute attribute = (DefaultEntryAttribute)in.readObject();
            if (this.schemaManager != null) {
                try {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(attribute.getId());
                    this.attributes.put(attributeType.getOid(), attribute);
                    continue;
                }
                catch (LdapException le) {
                    String message = le.getLocalizedMessage();
                    LOG.error(message);
                    throw new IOException(message);
                }
            }
            this.attributes.put(attribute.getId(), attribute);
        }
    }

    public void serialize(ObjectOutput out) throws IOException {
        if (this.dn.getRdn() == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            RdnSerializer.serialize(this.dn.getRdn(), out);
        }
        out.writeInt(this.attributes.size());
        if (this.schemaManager != null) {
            for (AttributeType attributeType : this.getAttributeTypes()) {
                String oid = attributeType.getOid();
                Unicode.writeUTF(out, oid);
                DefaultEntryAttribute attribute = (DefaultEntryAttribute)this.attributes.get(attributeType.getOid());
                attribute.writeExternal(out);
            }
        } else {
            for (String id : this.attributes.keySet()) {
                Unicode.writeUTF(out, id);
                DefaultEntryAttribute attribute = (DefaultEntryAttribute)this.attributes.get(id);
                attribute.writeExternal(out);
            }
        }
    }

    public void deserialize(ObjectInput in) throws IOException, ClassNotFoundException, LdapInvalidDnException {
        this.dn = Dn.EMPTY_DN;
        byte b = in.readByte();
        if (b == 1) {
            Rdn rdn = RdnSerializer.deserialize(this.schemaManager, in);
            this.dn = new Dn(rdn);
        }
        int nbAttributes = in.readInt();
        if (this.schemaManager != null) {
            for (int i = 0; i < nbAttributes; ++i) {
                String oid = Unicode.readUTF(in);
                try {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
                    DefaultEntryAttribute attribute = new DefaultEntryAttribute(attributeType);
                    attribute.readExternal(in);
                    this.attributes.put(attributeType.getOid(), attribute);
                    continue;
                }
                catch (LdapException ne) {
                    LOG.warn(I18n.err(I18n.ERR_04470, oid));
                }
            }
        } else {
            for (int i = 0; i < nbAttributes; ++i) {
                String id = Unicode.readUTF(in);
                DefaultEntryAttribute attribute = new DefaultEntryAttribute(id);
                attribute.readExternal(in);
                this.attributes.put(id, attribute);
            }
        }
    }

    private void rehash() {
        this.h = 37;
        this.h = this.h * 17 + this.dn.hashCode();
    }

    public int hashCode() {
        if (this.h == 0) {
            this.rehash();
        }
        return this.h;
    }

    @Override
    public boolean hasObjectClass(String objectClass) {
        if (this.schemaManager != null) {
            return this.contains(objectClassAttributeType, objectClass);
        }
        return this.contains("objectclass", objectClass);
    }

    @Override
    public boolean hasObjectClass(EntryAttribute objectClass) {
        if (objectClass == null) {
            return false;
        }
        if (!objectClass.getAttributeType().equals(objectClassAttributeType)) {
            return false;
        }
        EntryAttribute attribute = this.attributes.get(objectClassAttributeType.getOid());
        if (attribute == null) {
            return false;
        }
        for (Value value : objectClass) {
            if (attribute.contains(value.getString())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultEntry)) {
            return false;
        }
        DefaultEntry other = (DefaultEntry)o;
        return !(this.dn == null ? other.getDn() != null : !this.dn.equals(other.getDn()));
    }

    public String toString() {
        EntryAttribute objectClass;
        StringBuilder sb = new StringBuilder();
        sb.append("Entry\n");
        sb.append("    dn");
        if (this.dn.isNormalized()) {
            sb.append("[n]");
        }
        sb.append(": ");
        sb.append(this.dn.getName());
        sb.append('\n');
        if (this.schemaManager != null) {
            if (this.containsAttribute(objectClassAttributeType.getOid())) {
                objectClass = this.get(objectClassAttributeType);
                sb.append(objectClass);
            }
        } else if (this.containsAttribute("objectClass")) {
            objectClass = this.get("objectclass");
            sb.append(objectClass);
        }
        if (this.attributes.size() != 0) {
            for (EntryAttribute attribute : this.attributes.values()) {
                String id = attribute.getId();
                if (this.schemaManager != null) {
                    AttributeType attributeType = this.schemaManager.getAttributeType(id);
                    if (attributeType == objectClassAttributeType) continue;
                    sb.append(attribute);
                    continue;
                }
                if (id.equalsIgnoreCase("objectClass") || id.equals("2.5.4.0")) continue;
                sb.append(attribute);
            }
        }
        return sb.toString();
    }

    private void normalizeDN(Dn dn) {
        if (!dn.isNormalized()) {
            try {
                dn.normalize(this.schemaManager);
            }
            catch (LdapException ne) {
                LOG.warn("The Dn '{}' cannot be normalized", (Object)dn);
            }
        }
    }

    static {
        MUTEX = new Object();
    }
}

