/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.AbstractValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.model.schema.comparators.ByteArrayComparator;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryValue
extends AbstractValue<byte[]> {
    public static final long serialVersionUID = 2L;

    public BinaryValue() {
        this.wrappedValue = null;
        this.normalized = false;
        this.valid = null;
        this.normalizedValue = null;
    }

    public BinaryValue(AttributeType attributeType) {
        if (attributeType != null) {
            if (attributeType.getSyntax() == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04445, new Object[0]));
            }
            if (attributeType.getSyntax().isHumanReadable()) {
                LOG.warn("Treating a value of a human readible attribute {} as binary: ", (Object)attributeType.getName());
            }
            this.attributeType = attributeType;
        }
    }

    public BinaryValue(byte[] value) {
        if (value != null) {
            this.wrappedValue = new byte[value.length];
            System.arraycopy(value, 0, this.wrappedValue, 0, value.length);
        } else {
            this.wrappedValue = null;
        }
        this.normalized = false;
        this.valid = null;
        this.normalizedValue = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BinaryValue(AttributeType attributeType, byte[] value) {
        this(attributeType);
        if (attributeType == null) {
            this.wrappedValue = value;
            return;
        }
        SyntaxChecker syntaxChecker = attributeType.getSyntax().getSyntaxChecker();
        if (syntaxChecker == null) return;
        if (syntaxChecker.isValidSyntax(value)) {
            this.wrappedValue = value;
            return;
        }
        String msg = I18n.err(I18n.ERR_04479_INVALID_SYNTAX_VALUE, value, attributeType.getName());
        LOG.info(msg);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public byte[] getNormalizedValue() {
        if (this.isNull()) {
            return null;
        }
        if (!this.normalized) {
            try {
                this.normalize();
            }
            catch (LdapException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.warn(message);
                this.normalized = false;
            }
        }
        if (this.normalizedValue != null) {
            byte[] copy = new byte[((byte[])this.normalizedValue).length];
            System.arraycopy(this.normalizedValue, 0, copy, 0, ((byte[])this.normalizedValue).length);
            return copy;
        }
        return StringConstants.EMPTY_BYTES;
    }

    @Override
    public byte[] getNormalizedValueReference() {
        if (this.isNull()) {
            return null;
        }
        if (!this.isNormalized()) {
            try {
                this.normalize();
            }
            catch (LdapException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.warn(message);
                this.normalized = false;
            }
        }
        if (this.normalizedValue != null) {
            return (byte[])this.normalizedValue;
        }
        return (byte[])this.wrappedValue;
    }

    @Override
    public final void normalize(Normalizer normalizer) throws LdapException {
        if (normalizer != null) {
            if (this.wrappedValue == null) {
                this.normalizedValue = this.wrappedValue;
                this.normalized = true;
                this.same = true;
            } else {
                this.normalizedValue = normalizer.normalize(this).getBytes();
                this.normalized = true;
                this.same = Arrays.equals((byte[])this.wrappedValue, (byte[])this.normalizedValue);
            }
        } else {
            this.normalizedValue = this.wrappedValue;
            this.normalized = false;
            this.same = true;
        }
    }

    @Override
    public void normalize() throws LdapException {
        if (this.isNormalized()) {
            return;
        }
        if (this.attributeType != null) {
            Normalizer normalizer = this.getNormalizer();
            this.normalize(normalizer);
        } else {
            this.normalizedValue = this.wrappedValue;
            this.normalized = true;
            this.same = true;
        }
    }

    @Override
    public int compareTo(Value<byte[]> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        BinaryValue binaryValue = (BinaryValue)value;
        if (this.attributeType != null) {
            try {
                LdapComparator<byte[]> comparator = this.getLdapComparator();
                if (comparator != null) {
                    return comparator.compare(this.getNormalizedValueReference(), binaryValue.getNormalizedValueReference());
                }
                return new ByteArrayComparator(null).compare(this.getNormalizedValueReference(), binaryValue.getNormalizedValueReference());
            }
            catch (LdapException e) {
                String msg = I18n.err(I18n.ERR_04443, Arrays.toString((byte[])this.getReference()), value);
                LOG.error(msg, (Throwable)e);
                throw new IllegalStateException(msg, e);
            }
        }
        return new ByteArrayComparator(null).compare(this.getNormalizedValue(), binaryValue.getNormalizedValue());
    }

    public int hashCode() {
        if (this.h == 0) {
            if (this.isNull()) {
                return 0;
            }
            byte[] normalizedValue = this.getNormalizedValueReference();
            this.h = Arrays.hashCode(normalizedValue);
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BinaryValue)) {
            return false;
        }
        BinaryValue other = (BinaryValue)obj;
        if (this.isNull()) {
            return other.isNull();
        }
        if (this.attributeType != null) {
            if (other.attributeType != null) {
                if (!this.attributeType.equals(other.attributeType)) {
                    return false;
                }
            } else {
                other.attributeType = this.attributeType;
            }
        } else if (other.attributeType != null) {
            this.attributeType = other.attributeType;
        }
        if (Arrays.equals((byte[])this.wrappedValue, (byte[])other.wrappedValue)) {
            return true;
        }
        if (this.attributeType != null) {
            try {
                LdapComparator<byte[]> comparator = this.getLdapComparator();
                if (comparator == null) {
                    return Arrays.equals(this.getNormalizedValueReference(), other.getNormalizedValueReference());
                }
                return comparator.compare(this.getNormalizedValueReference(), other.getNormalizedValueReference()) == 0;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        return Arrays.equals(this.getNormalizedValueReference(), other.getNormalizedValueReference());
    }

    @Override
    public BinaryValue clone() {
        BinaryValue clone = (BinaryValue)super.clone();
        if (this.normalizedValue != null) {
            clone.normalizedValue = new byte[((byte[])this.normalizedValue).length];
            System.arraycopy(this.normalizedValue, 0, clone.normalizedValue, 0, ((byte[])this.normalizedValue).length);
        }
        if (this.wrappedValue != null) {
            clone.wrappedValue = new byte[((byte[])this.wrappedValue).length];
            System.arraycopy(this.wrappedValue, 0, clone.wrappedValue, 0, ((byte[])this.wrappedValue).length);
        }
        return clone;
    }

    @Override
    public byte[] get() {
        if (this.wrappedValue == null) {
            return null;
        }
        byte[] copy = new byte[((byte[])this.wrappedValue).length];
        System.arraycopy(this.wrappedValue, 0, copy, 0, ((byte[])this.wrappedValue).length);
        return copy;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public int length() {
        return this.wrappedValue != null ? ((byte[])this.wrappedValue).length : 0;
    }

    @Override
    public byte[] getBytes() {
        return this.get();
    }

    @Override
    public String getString() {
        return Strings.utf8ToString((byte[])this.wrappedValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isHR = in.readBoolean();
        if (isHR) {
            throw new IOException("The serialized value is not a Binary value");
        }
        int wrappedLength = in.readInt();
        if (wrappedLength >= 0) {
            this.wrappedValue = new byte[wrappedLength];
            if (wrappedLength > 0 && in.read((byte[])this.wrappedValue) == -1) {
                throw new IOException(I18n.err(I18n.ERR_04480_END_OF_STREAM, new Object[0]));
            }
        }
        this.normalized = in.readBoolean();
        if (this.normalized) {
            int normalizedLength = in.readInt();
            if (normalizedLength >= 0) {
                this.normalizedValue = new byte[normalizedLength];
                if (normalizedLength > 0) {
                    in.read((byte[])this.normalizedValue);
                }
            }
        } else if (wrappedLength >= 0) {
            this.normalizedValue = new byte[wrappedLength];
            System.arraycopy(this.wrappedValue, 0, this.normalizedValue, 0, wrappedLength);
        }
        this.h = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(false);
        if (this.wrappedValue != null) {
            out.writeInt(((byte[])this.wrappedValue).length);
            if (((byte[])this.wrappedValue).length > 0) {
                out.write((byte[])this.wrappedValue, 0, ((byte[])this.wrappedValue).length);
            }
        } else {
            out.writeInt(-1);
        }
        if (this.normalized) {
            out.writeBoolean(true);
            if (this.normalizedValue != null) {
                out.writeInt(((byte[])this.normalizedValue).length);
                if (((byte[])this.normalizedValue).length > 0) {
                    out.write((byte[])this.normalizedValue, 0, ((byte[])this.normalizedValue).length);
                }
            } else {
                out.writeInt(-1);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.h);
        out.flush();
    }

    public String toString() {
        if (this.wrappedValue == null) {
            return "null";
        }
        if (((byte[])this.wrappedValue).length > 16) {
            byte[] copy = new byte[16];
            System.arraycopy(this.wrappedValue, 0, copy, 0, 16);
            return "'" + Strings.dumpBytes(copy) + "...'";
        }
        return "'" + Strings.dumpBytes((byte[])this.wrappedValue) + "'";
    }
}

