/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.entry;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.LdapComparator;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.Normalizer;
import org.apache.directory.shared.ldap.model.schema.SyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValue<T>
implements Value<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractValue.class);
    protected transient AttributeType attributeType;
    protected T wrappedValue;
    protected T normalizedValue;
    protected boolean normalized;
    protected Boolean valid;
    protected boolean same;
    protected volatile int h;

    @Override
    public Value<T> clone() {
        try {
            return (Value)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public T getReference() {
        return this.wrappedValue;
    }

    @Override
    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public void apply(AttributeType attributeType) {
        String message;
        if (this.attributeType != null) {
            if (!attributeType.equals(this.attributeType)) {
                String message2 = I18n.err(I18n.ERR_04476, attributeType.getName(), this.attributeType.getName());
                LOG.info(message2);
                throw new IllegalArgumentException(message2);
            }
            return;
        }
        try {
            if (!this.isValid(attributeType.getSyntax().getSyntaxChecker())) {
                String message3 = I18n.err(I18n.ERR_04476, attributeType.getName(), this.attributeType.getName());
                LOG.info(message3);
                throw new IllegalArgumentException(message3);
            }
        }
        catch (LdapException le) {
            message = I18n.err(I18n.ERR_04447, le.getLocalizedMessage());
            LOG.info(message);
            this.normalized = false;
        }
        this.attributeType = attributeType;
        try {
            this.normalize();
        }
        catch (LdapException ne) {
            message = I18n.err(I18n.ERR_04447, ne.getLocalizedMessage());
            LOG.info(message);
            this.normalized = false;
        }
        this.h = 0;
        this.hashCode();
    }

    protected final LdapComparator<T> getLdapComparator() throws LdapException {
        if (this.attributeType != null) {
            MatchingRule mr = this.getMatchingRule();
            if (mr == null) {
                return null;
            }
            return mr.getLdapComparator();
        }
        return null;
    }

    protected final MatchingRule getMatchingRule() throws LdapException {
        if (this.attributeType != null) {
            MatchingRule mr = this.attributeType.getEquality();
            if (mr == null) {
                mr = this.attributeType.getOrdering();
            }
            if (mr == null) {
                mr = this.attributeType.getSubstring();
            }
            return mr;
        }
        return null;
    }

    protected final Normalizer getNormalizer() throws LdapException {
        if (this.attributeType != null) {
            MatchingRule mr = this.getMatchingRule();
            if (mr == null) {
                return null;
            }
            return mr.getNormalizer();
        }
        return null;
    }

    @Override
    public boolean instanceOf(AttributeType attributeType) throws LdapException {
        if (attributeType != null && this.attributeType.equals(attributeType)) {
            if (this.attributeType.equals(attributeType)) {
                return true;
            }
            return this.attributeType.isDescendantOf(attributeType);
        }
        return false;
    }

    @Override
    public T getNormalizedValueReference() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            return this.wrappedValue;
        }
        return this.normalizedValue;
    }

    @Override
    public final boolean isNull() {
        return this.wrappedValue == null;
    }

    final boolean isSame() {
        return this.same;
    }

    @Override
    public final boolean isValid() {
        if (this.valid != null) {
            return this.valid;
        }
        if (this.attributeType != null) {
            SyntaxChecker syntaxChecker = this.attributeType.getSyntax().getSyntaxChecker();
            Object value = this.getNormalizedValue();
            this.valid = syntaxChecker.isValidSyntax(value);
        } else {
            this.valid = false;
        }
        return this.valid;
    }

    @Override
    public final boolean isValid(SyntaxChecker syntaxChecker) throws LdapException {
        if (syntaxChecker == null) {
            String message = I18n.err(I18n.ERR_04139, this.toString());
            LOG.error(message);
            throw new LdapException(message);
        }
        this.valid = syntaxChecker.isValidSyntax(this.getReference());
        return this.valid;
    }

    @Override
    public void normalize() throws LdapException {
        this.normalized = true;
        this.normalizedValue = this.wrappedValue;
        this.h = 0;
        this.hashCode();
    }

    @Override
    public final boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public final void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }
}

