/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.cursor;

import java.util.Iterator;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.CursorIterator;
import org.apache.directory.shared.ldap.model.cursor.DefaultClosureMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCursor<E>
implements Cursor<E> {
    private ClosureMonitor monitor = new DefaultClosureMonitor();

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_02001_MONITOR, new Object[0]));
        }
        this.monitor = monitor;
    }

    protected final void checkNotClosed(String operation) throws Exception {
        this.monitor.checkNotClosed();
    }

    @Override
    public final boolean isClosed() {
        return this.monitor.isClosed();
    }

    @Override
    public void close(Exception cause) throws Exception {
        this.monitor.close(cause);
    }

    @Override
    public void close() throws Exception {
        this.monitor.close();
    }

    @Override
    public Iterator<E> iterator() {
        return new CursorIterator(this);
    }

    @Override
    public boolean isAfterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isAfterLast()")));
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isBeforeFirst()")));
    }

    @Override
    public boolean isFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isFirst()")));
    }

    @Override
    public boolean isLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isLast()")));
    }
}

