/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulShutdown;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulShutdownContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulShutdownStatesEnum;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GracefulShutdownGrammar
extends AbstractGrammar<GracefulShutdownContainer> {
    static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static GracefulShutdownGrammar instance = new GracefulShutdownGrammar();

    private GracefulShutdownGrammar() {
        this.setName(GracefulShutdownGrammar.class.getName());
        this.transitions = new GrammarTransition[GracefulShutdownStatesEnum.LAST_GRACEFUL_SHUTDOWN_STATE.ordinal()][256];
        this.transitions[GracefulShutdownStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<GracefulShutdownContainer>(GracefulShutdownStatesEnum.START_STATE, GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<GracefulShutdownContainer>("Init GracefulShutdown"){

            @Override
            public void action(GracefulShutdownContainer container) {
                GracefulShutdown gracefulShutdown = new GracefulShutdown();
                container.setGracefulShutdown(gracefulShutdown);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<GracefulShutdownContainer>(GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown time offline"){

            @Override
            public void action(GracefulShutdownContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    int timeOffline = IntegerDecoder.parse(value, 0, 720);
                    if (IS_DEBUG) {
                        LOG.debug("Time Offline = " + timeOffline);
                    }
                    container.getGracefulShutdown().setTimeOffline(timeOffline);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err(I18n.ERR_04037, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.TIME_OFFLINE_STATE.ordinal()][128] = new GrammarTransition<GracefulShutdownContainer>(GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, GracefulShutdownStatesEnum.DELAY_STATE, 128, new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown Delay"){

            @Override
            public void action(GracefulShutdownContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse(value, 0, 86400);
                    if (IS_DEBUG) {
                        LOG.debug("Delay = " + delay);
                    }
                    container.getGracefulShutdown().setDelay(delay);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err(I18n.ERR_04036, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition<GracefulShutdownContainer>(GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, GracefulShutdownStatesEnum.DELAY_STATE, 128, new GrammarAction<GracefulShutdownContainer>("Set Graceful Shutdown Delay"){

            @Override
            public void action(GracefulShutdownContainer container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse(value, 0, 86400);
                    if (IS_DEBUG) {
                        LOG.debug("Delay = " + delay);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setDelay(delay);
                    gracefulShutdownContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err(I18n.ERR_04036, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static GracefulShutdownGrammar getInstance() {
        return instance;
    }
}

