/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulAction;

public class GracefulShutdown
extends GracefulAction {
    private int gracefulSequenceLength;

    public int computeLength() {
        int gracefulLength = 2;
        this.gracefulSequenceLength = 0;
        if (this.timeOffline != 0) {
            this.gracefulSequenceLength += 2 + Value.getNbBytes(this.timeOffline);
        }
        if (this.delay != 0) {
            this.gracefulSequenceLength += 2 + Value.getNbBytes(this.delay);
        }
        return gracefulLength + this.gracefulSequenceLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.gracefulSequenceLength));
        if (this.timeOffline != 0) {
            Value.encode(bb, this.timeOffline);
        }
        if (this.delay != 0) {
            bb.put((byte)-128);
            bb.put((byte)Value.getNbBytes(this.delay));
            bb.put(Value.getBytes(this.delay));
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Graceful Shutdown extended operation");
        sb.append("    TimeOffline : ").append(this.timeOffline).append('\n');
        sb.append("    Delay : ").append(this.delay).append('\n');
        return sb.toString();
    }
}

