/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.extras.extended.GracefulDisconnectResponse;
import org.apache.directory.shared.ldap.extras.extended.GracefulDisconnectResponseImpl;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnect;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnectContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnectDecoder;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.filter.LdapURL;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.ReferralImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GracefulDisconnectResponseDecorator
extends ExtendedResponseDecorator<GracefulDisconnectResponse>
implements GracefulDisconnectResponse {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulDisconnectResponseDecorator.class);

    public GracefulDisconnectResponseDecorator(LdapCodecService codec, GracefulDisconnectResponse decoratedMessage) {
        super(codec, decoratedMessage);
        this.responseValue = null;
        this.encodeResponse();
    }

    public GracefulDisconnectResponseDecorator(LdapCodecService codec, byte[] responseValue) throws DecoderException {
        super(codec, new GracefulDisconnectResponseImpl());
        this.responseValue = responseValue;
        this.decodeValue();
    }

    private void decodeValue() throws DecoderException {
        GracefulDisconnectDecoder decoder = new GracefulDisconnectDecoder();
        GracefulDisconnect codec = null;
        try {
            codec = (GracefulDisconnect)decoder.decode(this.responseValue);
            ((GracefulDisconnectResponse)this.getDecorated()).setTimeOffline(codec.getTimeOffline());
            ((GracefulDisconnectResponse)this.getDecorated()).setDelay(codec.getDelay());
            ((GracefulDisconnectResponse)this.getDecorated()).getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
            List<LdapURL> contexts = codec.getReplicatedContexts();
            for (LdapURL ldapUrl : contexts) {
                ((GracefulDisconnectResponse)this.getDecorated()).getLdapResult().getReferral().addLdapUrl(ldapUrl.toString());
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_04169, new Object[0]), (Throwable)e);
            throw e;
        }
    }

    private void encodeResponse() {
        GracefulDisconnect codec = new GracefulDisconnect();
        codec.setTimeOffline(((GracefulDisconnectResponse)this.getDecorated()).getTimeOffline());
        codec.setDelay(((GracefulDisconnectResponse)this.getDecorated()).getDelay());
        for (String ldapUrlStr : ((GracefulDisconnectResponse)this.getDecorated()).getLdapResult().getReferral().getLdapUrls()) {
            LdapURL ldapUrl = null;
            try {
                ldapUrl = new LdapURL(ldapUrlStr);
            }
            catch (LdapURLEncodingException e) {
                LOG.error(I18n.err(I18n.ERR_04170, ldapUrlStr), (Throwable)e);
                continue;
            }
            codec.addReplicatedContexts(ldapUrl);
        }
        try {
            this.responseValue = codec.encode().array();
        }
        catch (EncoderException e) {
            LOG.error(I18n.err(I18n.ERR_04171, new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            this.encodeResponse();
        }
        byte[] copy = new byte[this.responseValue.length];
        System.arraycopy(this.responseValue, 0, copy, 0, this.responseValue.length);
        return copy;
    }

    @Override
    public void setResponseValue(byte[] responseValue) {
        if (responseValue == null) {
            this.responseValue = null;
            ((GracefulDisconnectResponse)this.getDecorated()).setDelay(0);
            ((GracefulDisconnectResponse)this.getDecorated()).setTimeOffline(0);
            ((GracefulDisconnectResponse)this.getDecorated()).getLdapResult().setReferral(new ReferralImpl());
            return;
        }
        ByteBuffer bb = ByteBuffer.wrap(responseValue);
        GracefulDisconnectContainer container = new GracefulDisconnectContainer();
        Asn1Decoder decoder = new Asn1Decoder();
        try {
            decoder.decode(bb, container);
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_04172, new Object[0]), (Throwable)e);
        }
        GracefulDisconnect codec = container.getGracefulDisconnect();
        ((GracefulDisconnectResponse)this.getDecorated()).setDelay(codec.getDelay());
        ((GracefulDisconnectResponse)this.getDecorated()).setTimeOffline(codec.getTimeOffline());
        for (LdapURL ldapUrl : codec.getReplicatedContexts()) {
            ((GracefulDisconnectResponse)this.getDecorated()).getLdapResult().getReferral().addLdapUrl(ldapUrl.toString());
        }
        this.responseValue = new byte[responseValue.length];
        System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
    }

    @Override
    public int getDelay() {
        return ((GracefulDisconnectResponse)this.getDecorated()).getDelay();
    }

    @Override
    public void setDelay(int delay) {
        ((GracefulDisconnectResponse)this.getDecorated()).setDelay(delay);
    }

    @Override
    public int getTimeOffline() {
        return ((GracefulDisconnectResponse)this.getDecorated()).getTimeOffline();
    }

    @Override
    public void setTimeOffline(int timeOffline) {
        ((GracefulDisconnectResponse)this.getDecorated()).setTimeOffline(timeOffline);
    }

    @Override
    public Referral getReplicatedContexts() {
        return ((GracefulDisconnectResponse)this.getDecorated()).getReplicatedContexts();
    }
}

