/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecServiceFactory;
import org.apache.directory.shared.ldap.extras.extended.CertGenerationRequestImpl;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.CertGenerationContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.CertGenerationRequestDecorator;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.CertGenerationStatesEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertGenerationGrammar
extends AbstractGrammar<CertGenerationContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<CertGenerationContainer> instance = new CertGenerationGrammar();

    public CertGenerationGrammar() {
        this.setName(CertGenerationGrammar.class.getName());
        this.transitions = new GrammarTransition[CertGenerationStatesEnum.LAST_CERT_GENERATION_STATE.ordinal()][256];
        this.transitions[CertGenerationStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<CertGenerationContainer>(CertGenerationStatesEnum.START_STATE, CertGenerationStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<CertGenerationContainer>("Init CertGenerationObject"){

            @Override
            public void action(CertGenerationContainer container) {
                CertGenerationRequestDecorator certGenerationObject = new CertGenerationRequestDecorator(LdapCodecServiceFactory.getSingleton(), new CertGenerationRequestImpl());
                container.setCertGenerationObject(certGenerationObject);
            }
        });
        this.transitions[CertGenerationStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<CertGenerationContainer>(CertGenerationStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE, CertGenerationStatesEnum.TARGETDN_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<CertGenerationContainer>("Set Cert Generation target Dn value"){

            @Override
            public void action(CertGenerationContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                String targetDN = Strings.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("Target Dn = " + targetDN);
                }
                if (targetDN != null && targetDN.trim().length() > 0) {
                    if (!Dn.isValid(targetDN)) {
                        String msg = I18n.err(I18n.ERR_04032, targetDN);
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err(I18n.ERR_04033, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.getCertGenerationObject().setTargetDN(targetDN);
            }
        });
        this.transitions[CertGenerationStatesEnum.TARGETDN_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<CertGenerationContainer>(CertGenerationStatesEnum.TARGETDN_STATE, CertGenerationStatesEnum.ISSUER_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<CertGenerationContainer>("Set Cert Generation issuer Dn value"){

            @Override
            public void action(CertGenerationContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                String issuerDN = Strings.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("Issuer Dn = " + issuerDN);
                }
                if (issuerDN != null && issuerDN.trim().length() > 0) {
                    if (!Dn.isValid(issuerDN)) {
                        String msg = I18n.err(I18n.ERR_04034, issuerDN);
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    container.getCertGenerationObject().setIssuerDN(issuerDN);
                }
            }
        });
        this.transitions[CertGenerationStatesEnum.ISSUER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<CertGenerationContainer>(CertGenerationStatesEnum.ISSUER_STATE, CertGenerationStatesEnum.SUBJECT_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<CertGenerationContainer>("Set Cert Generation subject Dn value"){

            @Override
            public void action(CertGenerationContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                String subjectDN = Strings.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("subject Dn = " + subjectDN);
                }
                if (subjectDN != null && subjectDN.trim().length() > 0) {
                    if (!Dn.isValid(subjectDN)) {
                        String msg = I18n.err(I18n.ERR_04035, subjectDN);
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err(I18n.ERR_04033, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.getCertGenerationObject().setSubjectDN(subjectDN);
            }
        });
        this.transitions[CertGenerationStatesEnum.SUBJECT_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<CertGenerationContainer>(CertGenerationStatesEnum.SUBJECT_STATE, CertGenerationStatesEnum.KEY_ALGORITHM_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<CertGenerationContainer>("Set Cert Generation key algorithm value"){

            @Override
            public void action(CertGenerationContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                String keyAlgorithm = Strings.utf8ToString(value.getData());
                if (IS_DEBUG) {
                    LOG.debug("key algorithm = " + keyAlgorithm);
                }
                if (keyAlgorithm != null && keyAlgorithm.trim().length() > 0) {
                    container.getCertGenerationObject().setKeyAlgorithm(keyAlgorithm);
                }
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<CertGenerationContainer> getInstance() {
        return instance;
    }
}

