/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.standalone;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.ldap.codec.BasicControlDecorator;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.ControlFactory;
import org.apache.directory.shared.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.shared.ldap.codec.api.ExtendedRequestFactory;
import org.apache.directory.shared.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.UnsolicitedResponseFactory;
import org.apache.directory.shared.ldap.codec.controls.cascade.CascadeDecorator;
import org.apache.directory.shared.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.shared.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.shared.ldap.codec.standalone.CodecHostActivator;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.controls.Cascade;
import org.apache.directory.shared.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.shared.util.OsgiUtils;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.exception.NotImplementedException;
import org.apache.felix.framework.Felix;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneLdapCodecService
implements LdapCodecService {
    public static final String FELIX_CACHE_LOCKING = "felix.cache.locking";
    public static final String FELIX_CACHE_ROOTDIR = "felix.cache.rootdir";
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneLdapCodecService.class);
    private static final String[] SYSTEM_PACKAGES = new String[]{"org.slf4j; version=1.6.0", "org.apache.directory.shared.i18n; version=1.0.0", "org.apache.directory.shared.util; version=1.0.0", "org.apache.directory.shared.util.exception; version=1.0.0", "org.apache.directory.shared.asn1; version=1.0.0", "org.apache.directory.shared.asn1.util; version=1.0.0", "org.apache.directory.shared.asn1.ber; version=1.0.0", "org.apache.directory.shared.asn1.ber.tlv; version=1.0.0", "org.apache.directory.shared.asn1.ber.grammar; version=1.0.0", "org.apache.directory.shared.asn1.actions; version=1.0.0", "org.apache.directory.shared.ldap.asn1.ber; version=1.0.0", "org.apache.directory.shared.ldap.model; version=1.0.0", "org.apache.directory.shared.ldap.model.exception; version=1.0.0", "org.apache.directory.shared.ldap.model.filter; version=1.0.0", "org.apache.directory.shared.ldap.model.name; version=1.0.0", "org.apache.directory.shared.ldap.model.entry; version=1.0.0", "org.apache.directory.shared.ldap.model.schema; version=1.0.0", "org.apache.directory.shared.ldap.model.message; version=1.0.0", "org.apache.directory.shared.ldap.model.message.controls; version=1.0.0", "org.apache.directory.shared.ldap.codec.controls; version=1.0.0", "org.apache.directory.shared.ldap.codec.api; version=1.0.0", "org.apache.directory.shared.ldap.extras.controls", "org.apache.directory.shared.ldap.extras.extended"};
    public static final String PLUGIN_DIRECTORY_PROPERTY = "codec.plugin.directory";
    private Map<String, ControlFactory<?, ?>> controlFactories = new HashMap();
    private Map<String, ExtendedRequestFactory<?, ?>> extReqFactories = new HashMap();
    private Map<String, UnsolicitedResponseFactory<?>> unsolicitedFactories = new HashMap();
    private ProtocolCodecFactory protocolCodecFactory;
    private CodecHostActivator activator;
    private Felix felix;
    private final File cacheDirectory;
    private final File pluginDirectory;

    public StandaloneLdapCodecService() {
        this(null, null);
    }

    public StandaloneLdapCodecService(File pluginDirectory, File cacheDirectory) {
        if (pluginDirectory == null) {
            this.pluginDirectory = this.getPluginDirectoryDefault();
            LOG.info("Null plugin directory provided, using default instead: {}", (Object)this.pluginDirectory);
        } else {
            this.pluginDirectory = pluginDirectory;
            LOG.info("Valid plugin directory provided: {}", (Object)this.pluginDirectory);
        }
        if (this.pluginDirectory != null && !this.pluginDirectory.exists()) {
            this.pluginDirectory.mkdirs();
        }
        if (this.pluginDirectory != null) {
            if (!this.pluginDirectory.isDirectory()) {
                String msg = "The provided plugin directory is not a directory:" + this.pluginDirectory.getAbsolutePath();
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            if (!this.pluginDirectory.canRead()) {
                String msg = "The provided plugin directory is not readable:" + this.pluginDirectory.getAbsolutePath();
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        if (cacheDirectory == null) {
            this.cacheDirectory = this.getCacheDirectoryDefault();
            LOG.info("Null cache directory provided, using default instead: {}", (Object)this.cacheDirectory);
        } else {
            this.cacheDirectory = cacheDirectory;
            LOG.info("Valid cache directory provided: {}", (Object)this.cacheDirectory);
        }
        if (this.cacheDirectory != null && !this.cacheDirectory.exists()) {
            this.cacheDirectory.mkdirs();
        }
        if (this.cacheDirectory != null) {
            if (!this.cacheDirectory.isDirectory()) {
                String msg = "The provided cache directory is not a directory:" + this.cacheDirectory.getAbsolutePath();
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            if (!this.cacheDirectory.canRead()) {
                String msg = "The provided cache directory is not readable:" + this.cacheDirectory.getAbsolutePath();
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        this.loadStockControls();
        this.setupFelix();
        if (this.protocolCodecFactory == null) {
            try {
                Class<?> clazz = Class.forName("org.apache.directory.shared.ldap.codec.protocol.mina.LdapProtocolCodecFactory");
                this.protocolCodecFactory = (ProtocolCodecFactory)clazz.newInstance();
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to load default codec factory.", cause);
            }
        }
    }

    private File getCacheDirectoryDefault() {
        String frameworkStorage = System.getProperties().getProperty("org.osgi.framework.storage");
        LOG.info("{}: {}", (Object)"org.osgi.framework.storage", (Object)frameworkStorage);
        String felixCacheRootdir = System.getProperties().getProperty(FELIX_CACHE_ROOTDIR);
        LOG.info("{}: {}", (Object)FELIX_CACHE_ROOTDIR, (Object)felixCacheRootdir);
        try {
            if (frameworkStorage == null && felixCacheRootdir == null) {
                return new File(File.createTempFile("dummy", null).getParentFile(), "osgi-cache-" + Integer.toString(this.hashCode()));
            }
            if (frameworkStorage == null && felixCacheRootdir != null) {
                return new File(new File(felixCacheRootdir), "osgi-cache-" + Integer.toString(this.hashCode()));
            }
            if (frameworkStorage != null && felixCacheRootdir == null) {
                return new File(frameworkStorage + "-" + Integer.toString(this.hashCode()));
            }
            return new File(new File(felixCacheRootdir), frameworkStorage + "-" + Integer.toString(this.hashCode()));
        }
        catch (Exception e) {
            String message = "Failure to create temporary cache directory: " + e.getMessage();
            LOG.warn(message, (Throwable)e);
            return null;
        }
    }

    private File getPluginDirectoryDefault() {
        String value = System.getProperty(PLUGIN_DIRECTORY_PROPERTY);
        LOG.info("{}: {}", (Object)PLUGIN_DIRECTORY_PROPERTY, (Object)value);
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    private String getSystemPackages() {
        HashSet<String> pkgs = new HashSet<String>();
        String sysProp = System.getProperty("org.osgi.framework.system.packages.extra");
        if (sysProp != null) {
            OsgiUtils.splitIntoPackages(sysProp, pkgs);
        }
        OsgiUtils.getAllBundleExports(null, pkgs);
        Collections.addAll(pkgs, SYSTEM_PACKAGES);
        StringBuilder sb = new StringBuilder();
        Iterator i = pkgs.iterator();
        while (i.hasNext()) {
            String pkg = (String)i.next();
            sb.append(pkg);
            LOG.debug("Adding system extras package: {}", (Object)pkg);
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private void setupFelix() {
        this.activator = new CodecHostActivator(this);
        ArrayList<CodecHostActivator> activators = new ArrayList<CodecHostActivator>();
        activators.add(this.activator);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("felix.systembundle.activators", activators);
        config.put("org.osgi.framework.system.packages.extra", this.getSystemPackages());
        config.put(FELIX_CACHE_ROOTDIR, this.cacheDirectory.getParent());
        config.put("org.osgi.framework.storage", this.cacheDirectory.getName());
        if (System.getProperties().getProperty("org.osgi.framework.storage.clean") != null) {
            String cleanMode = System.getProperties().getProperty("org.osgi.framework.storage.clean");
            config.put("org.osgi.framework.storage.clean", cleanMode);
            LOG.info("Using framework storage clean value from sytem properties: {}", (Object)cleanMode);
        } else {
            config.put("org.osgi.framework.storage.clean", "none");
            LOG.info("Using framework storage clean defaults: none");
        }
        if (System.getProperties().getProperty(FELIX_CACHE_LOCKING) != null) {
            String lockCache = System.getProperties().getProperty(FELIX_CACHE_LOCKING);
            config.put(FELIX_CACHE_LOCKING, lockCache);
            LOG.info("Using framework cache locking setting from sytem properties: {}", (Object)lockCache);
        } else {
            config.put(FELIX_CACHE_LOCKING, "true");
            LOG.info("Using default for cache locking: enabled");
        }
        this.felix = new Felix(config);
        try {
            this.felix.start();
        }
        catch (BundleException e) {
            String message = "Failed to start embedded felix instance: " + e.getMessage();
            LOG.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public void shutdown() {
        LOG.info("Attempt to shutdown the codec service");
        try {
            this.felix.stop();
            this.felix.waitForStop(0L);
        }
        catch (Exception e) {
            String message = "Failed to stop embedded felix instance: " + e.getMessage();
            LOG.error(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    private void loadStockControls() {
        ControlFactory<Cascade, CascadeDecorator> factory = new CascadeFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new EntryChangeFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new ManageDsaITFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PagedResultsFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PersistentSearchFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SubentriesFactory(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
    }

    @Override
    public ControlFactory<?, ?> registerControl(ControlFactory<?, ?> factory) {
        return this.controlFactories.put(factory.getOid(), factory);
    }

    @Override
    public ControlFactory<?, ?> unregisterControl(String oid) {
        return this.controlFactories.remove(oid);
    }

    @Override
    public Iterator<String> registeredControls() {
        return Collections.unmodifiableSet(this.controlFactories.keySet()).iterator();
    }

    @Override
    public boolean isControlRegistered(String oid) {
        return this.controlFactories.containsKey(oid);
    }

    @Override
    public Iterator<String> registeredExtendedRequests() {
        return Collections.unmodifiableSet(this.extReqFactories.keySet()).iterator();
    }

    @Override
    public ExtendedRequestFactory<?, ?> registerExtendedRequest(ExtendedRequestFactory<?, ?> factory) {
        return this.extReqFactories.put(factory.getOid(), factory);
    }

    @Override
    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.protocolCodecFactory;
    }

    @Override
    public ProtocolCodecFactory registerProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        ProtocolCodecFactory old = this.protocolCodecFactory;
        this.protocolCodecFactory = protocolCodecFactory;
        return old;
    }

    @Override
    public CodecControl<? extends Control> newControl(String oid) {
        ControlFactory<?, ?> factory = this.controlFactories.get(oid);
        if (factory == null) {
            return new BasicControlDecorator((LdapCodecService)this, new OpaqueControl(oid));
        }
        return factory.newCodecControl();
    }

    @Override
    public CodecControl<? extends Control> newControl(Control control) {
        if (control == null) {
            throw new NullPointerException("Control argument was null.");
        }
        if (control instanceof CodecControl) {
            return (CodecControl)control;
        }
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getOid());
        if (factory == null) {
            return new BasicControlDecorator((LdapCodecService)this, control);
        }
        return factory.newCodecControl(control);
    }

    @Override
    public javax.naming.ldap.Control toJndiControl(Control control) throws EncoderException {
        CodecControl<? extends Control> decorator = this.newControl(control);
        ByteBuffer bb = ByteBuffer.allocate(decorator.computeLength());
        decorator.encode(bb);
        bb.flip();
        BasicControl jndiControl = new BasicControl(control.getOid(), control.isCritical(), bb.array());
        return jndiControl;
    }

    @Override
    public Control fromJndiControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapCodecService)this, ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        Object ourControl = factory.newCodecControl();
        ourControl.setCritical(control.isCritical());
        ourControl.setValue(control.getEncodedValue());
        ourControl.decode(control.getEncodedValue());
        return ourControl;
    }

    @Override
    public Asn1Container newMessageContainer() {
        return new LdapMessageContainer(this);
    }

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }

    @Override
    public Iterator<String> registeredUnsolicitedResponses() {
        return Collections.unmodifiableSet(this.unsolicitedFactories.keySet()).iterator();
    }

    @Override
    public UnsolicitedResponseFactory<?> registerUnsolicitedResponse(UnsolicitedResponseFactory<?> factory) {
        return this.unsolicitedFactories.put(factory.getOid(), factory);
    }

    @Override
    public javax.naming.ldap.ExtendedResponse toJndi(ExtendedResponse modelResponse) throws EncoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    @Override
    public ExtendedResponse fromJndi(javax.naming.ldap.ExtendedResponse jndiResponse) throws DecoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    @Override
    public ExtendedRequestFactory<?, ?> unregisterExtendedRequest(String oid) {
        return this.extReqFactories.remove(oid);
    }

    @Override
    public UnsolicitedResponseFactory<?> unregisterUnsolicitedResponse(String oid) {
        return this.unsolicitedFactories.remove(oid);
    }

    @Override
    public ExtendedRequest<?> fromJndi(javax.naming.ldap.ExtendedRequest jndiRequest) throws DecoderException {
        ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)this.newExtendedRequest(jndiRequest.getID(), jndiRequest.getEncodedValue());
        return decorator;
    }

    @Override
    public javax.naming.ldap.ExtendedRequest toJndi(final ExtendedRequest<?> modelRequest) throws EncoderException {
        byte[] value;
        final String oid = modelRequest.getRequestName();
        if (modelRequest instanceof ExtendedRequestDecorator) {
            ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)modelRequest;
            value = decorator.getRequestValue();
        } else {
            ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(modelRequest.getRequestName());
            ExtendedRequestDecorator<?, ?> decorator = extendedRequestFactory.decorate(modelRequest);
            value = decorator.getRequestValue();
        }
        javax.naming.ldap.ExtendedRequest jndiRequest = new javax.naming.ldap.ExtendedRequest(){
            private static final long serialVersionUID = -4160980385909987475L;

            public String getID() {
                return oid;
            }

            public byte[] getEncodedValue() {
                return value;
            }

            public javax.naming.ldap.ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
                ExtendedRequestFactory factory = (ExtendedRequestFactory)StandaloneLdapCodecService.this.extReqFactories.get(modelRequest.getRequestName());
                try {
                    final ExtendedResponseDecorator resp = (ExtendedResponseDecorator)factory.newResponse(berValue);
                    javax.naming.ldap.ExtendedResponse jndiResponse = new javax.naming.ldap.ExtendedResponse(){
                        private static final long serialVersionUID = -7686354122066100703L;

                        public String getID() {
                            return oid;
                        }

                        public byte[] getEncodedValue() {
                            return resp.getResponseValue();
                        }
                    };
                    return jndiResponse;
                }
                catch (DecoderException e) {
                    NamingException ne = new NamingException("Unable to decode encoded response value: " + Strings.dumpBytes(berValue));
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        };
        return jndiRequest;
    }

    @Override
    public <E extends ExtendedResponse> E newExtendedResponse(ExtendedRequest<E> req, byte[] serializedResponse) throws DecoderException {
        ExtendedResponseDecorator<ExtendedResponseImpl> resp;
        ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(req.getRequestName());
        if (extendedRequestFactory != null) {
            resp = (ExtendedResponseDecorator<ExtendedResponseImpl>)extendedRequestFactory.newResponse(serializedResponse);
        } else {
            resp = new ExtendedResponseDecorator<ExtendedResponseImpl>((LdapCodecService)this, new ExtendedResponseImpl(req.getRequestName()));
            resp.setResponseValue(serializedResponse);
            resp.setResponseName(req.getRequestName());
        }
        resp.setMessageId(req.getMessageId());
        return (E)resp;
    }

    @Override
    public ExtendedRequest<?> newExtendedRequest(String oid, byte[] value) {
        ExtendedRequestDecorator req = null;
        ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(oid);
        if (extendedRequestFactory != null) {
            req = value == null ? (ExtendedRequestDecorator)extendedRequestFactory.newRequest() : (ExtendedRequestDecorator)extendedRequestFactory.newRequest(value);
        } else {
            ExtendedRequestDecorator decorator = new ExtendedRequestDecorator((LdapCodecService)this, new ExtendedRequestImpl());
            decorator.setRequestName(oid);
            decorator.setRequestValue(value);
            req = decorator;
        }
        return req;
    }

    @Override
    public ExtendedRequestDecorator<?, ?> decorate(ExtendedRequest<?> decoratedMessage) {
        ExtendedRequestDecorator<Object, Object> req = null;
        ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(decoratedMessage.getRequestName());
        req = extendedRequestFactory != null ? extendedRequestFactory.decorate(decoratedMessage) : new ExtendedRequestDecorator((LdapCodecService)this, decoratedMessage);
        return req;
    }

    @Override
    public ExtendedResponseDecorator<?> decorate(ExtendedResponse decoratedMessage) {
        ExtendedResponseDecorator<Object> resp = null;
        UnsolicitedResponseFactory<?> unsolicitedResponseFactory = this.unsolicitedFactories.get(decoratedMessage.getResponseName());
        ExtendedRequestFactory<?, ?> extendedRequestFactory = this.extReqFactories.get(decoratedMessage.getResponseName());
        resp = extendedRequestFactory != null ? extendedRequestFactory.decorate(decoratedMessage) : (unsolicitedResponseFactory != null ? unsolicitedResponseFactory.decorate(decoratedMessage) : new ExtendedResponseDecorator<ExtendedResponse>((LdapCodecService)this, decoratedMessage));
        return resp;
    }

    @Override
    public boolean isExtendedOperationRegistered(String oid) {
        return this.extReqFactories.containsKey(oid) || this.unsolicitedFactories.containsKey(oid);
    }
}

