/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.standalone;

import java.io.File;
import java.io.FileFilter;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.standalone.StandaloneLdapCodecService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class CodecHostActivator
implements BundleActivator {
    private StandaloneLdapCodecService codec;
    private ServiceRegistration registration;
    private BundleContext bundleContext;

    public CodecHostActivator(StandaloneLdapCodecService codec) {
        this.codec = codec;
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.registration = bundleContext.registerService(LdapCodecService.class.getName(), (Object)this.codec, null);
        if (this.codec.getPluginDirectory() != null) {
            File[] files;
            for (File file : files = this.codec.getPluginDirectory().listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.canRead() && pathname.isFile() && pathname.getAbsolutePath().endsWith(".jar");
                }
            })) {
                Bundle bundle = bundleContext.installBundle(file.toURI().toURL().toExternalForm());
                bundle.start();
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.registration.unregister();
        this.bundleContext = null;
    }

    public Bundle[] getBundles() {
        if (this.bundleContext != null) {
            return this.bundleContext.getBundles();
        }
        return null;
    }
}

