/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyResponseDecorator
extends ResponseDecorator<ModifyResponse>
implements ModifyResponse {
    private int modifyResponseLength;

    public ModifyResponseDecorator(LdapCodecService codec, ModifyResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setModifyResponseLength(int modifyResponseLength) {
        this.modifyResponseLength = modifyResponseLength;
    }

    public int getModifyResponseLength() {
        return this.modifyResponseLength;
    }

    @Override
    public int computeLength() {
        int modifyResponseLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        this.setModifyResponseLength(modifyResponseLength);
        return 1 + TLV.getNbBytes(modifyResponseLength) + modifyResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)103);
            buffer.put(TLV.getBytes(this.getModifyResponseLength()));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

