/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.shared.ldap.model.entry.DefaultEntryAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.EntryAttribute;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.name.Dn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequestDecorator
extends SingleReplyRequestDecorator<ModifyRequest, ModifyResponse>
implements ModifyRequest {
    private int modifyRequestLength;
    private int changesLength;
    private List<Integer> changeLength = new LinkedList<Integer>();
    private List<Integer> modificationLength = new LinkedList<Integer>();
    private List<Integer> valuesLength = new LinkedList<Integer>();
    private EntryAttribute currentAttribute;
    private ModificationOperation currentOperation;

    public ModifyRequestDecorator(LdapCodecService codec, ModifyRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setModifyRequestLength(int modifyRequestLength) {
        this.modifyRequestLength = modifyRequestLength;
    }

    public int getModifyRequestLength() {
        return this.modifyRequestLength;
    }

    public void setChangesLength(int changesLength) {
        this.changesLength = changesLength;
    }

    public int getChangesLength() {
        return this.changesLength;
    }

    public void setChangeLength(List<Integer> changeLength) {
        this.changeLength = changeLength;
    }

    public List<Integer> getChangeLength() {
        return this.changeLength;
    }

    public void setModificationLength(List<Integer> modificationLength) {
        this.modificationLength = modificationLength;
    }

    public List<Integer> getModificationLength() {
        return this.modificationLength;
    }

    public void setValuesLength(List<Integer> valuesLength) {
        this.valuesLength = valuesLength;
    }

    public List<Integer> getValuesLength() {
        return this.valuesLength;
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = ModificationOperation.getOperation(currentOperation);
    }

    public void addAttributeTypeAndValues(String type) {
        this.currentAttribute = new DefaultEntryAttribute(type);
        DefaultModification modification = new DefaultModification(this.currentOperation, this.currentAttribute);
        ((ModifyRequest)this.getDecorated()).addModification(modification);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getUpId();
    }

    public void addAttributeValue(byte[] value) {
        this.currentAttribute.add(new byte[][]{value});
    }

    public void addAttributeValue(String value) {
        this.currentAttribute.add(value);
    }

    @Override
    public Dn getName() {
        return ((ModifyRequest)this.getDecorated()).getName();
    }

    @Override
    public void setName(Dn name) {
        ((ModifyRequest)this.getDecorated()).setName(name);
    }

    @Override
    public Collection<Modification> getModifications() {
        return ((ModifyRequest)this.getDecorated()).getModifications();
    }

    @Override
    public void addModification(Modification mod) {
        ((ModifyRequest)this.getDecorated()).addModification(mod);
    }

    @Override
    public void removeModification(Modification mod) {
        ((ModifyRequest)this.getDecorated()).removeModification(mod);
    }

    @Override
    public void remove(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName, attributeValue);
    }

    @Override
    public void remove(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).remove(attributeName, attributeValue);
    }

    @Override
    public void remove(EntryAttribute attr) {
        ((ModifyRequest)this.getDecorated()).remove(attr);
    }

    @Override
    public void addModification(EntryAttribute attr, ModificationOperation modOp) {
        ((ModifyRequest)this.getDecorated()).addModification(attr, modOp);
    }

    @Override
    public void add(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).add(attributeName, attributeValue);
    }

    @Override
    public void add(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).add(attributeName, attributeValue);
    }

    @Override
    public void add(EntryAttribute attr) {
        ((ModifyRequest)this.getDecorated()).add(attr);
    }

    @Override
    public void replace(String attributeName) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName);
    }

    @Override
    public void replace(String attributeName, String ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName, attributeValue);
    }

    @Override
    public void replace(String attributeName, byte[] ... attributeValue) {
        ((ModifyRequest)this.getDecorated()).replace(attributeName, attributeValue);
    }

    @Override
    public void replace(EntryAttribute attr) {
        ((ModifyRequest)this.getDecorated()).replace(attr);
    }

    @Override
    public int computeLength() {
        int modifyRequestLength = 1 + TLV.getNbBytes(Dn.getNbBytes(this.getName())) + Dn.getNbBytes(this.getName());
        int changesLength = 0;
        Collection<Modification> modifications = this.getModifications();
        if (modifications != null && modifications.size() != 0) {
            LinkedList<Integer> changeLength = new LinkedList<Integer>();
            LinkedList<Integer> modificationLength = new LinkedList<Integer>();
            LinkedList<Integer> valuesLength = new LinkedList<Integer>();
            for (Modification modification : modifications) {
                int localModificationSequenceLength = 3;
                int localValuesLength = 0;
                int typeLength = modification.getAttribute().getUpId().length();
                int localModificationLength = 1 + TLV.getNbBytes(typeLength) + typeLength;
                if (modification.getAttribute().size() != 0) {
                    for (Value value : modification.getAttribute()) {
                        localValuesLength += 1 + TLV.getNbBytes(value.getBytes().length) + value.getBytes().length;
                    }
                }
                changesLength += 1 + TLV.getNbBytes(localModificationSequenceLength += 1 + TLV.getNbBytes(localModificationLength += 1 + TLV.getNbBytes(localValuesLength) + localValuesLength) + localModificationLength) + localModificationSequenceLength;
                valuesLength.add(localValuesLength);
                modificationLength.add(localModificationLength);
                changeLength.add(localModificationSequenceLength);
            }
            modifyRequestLength += 1 + TLV.getNbBytes(changesLength) + changesLength;
            this.setChangeLength(changeLength);
            this.setModificationLength(modificationLength);
            this.setValuesLength(valuesLength);
        }
        this.setChangesLength(changesLength);
        this.setModifyRequestLength(modifyRequestLength);
        return 1 + TLV.getNbBytes(modifyRequestLength) + modifyRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)102);
            buffer.put(TLV.getBytes(this.getModifyRequestLength()));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, Dn.getBytes(this.getName()));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes(this.getChangesLength()));
            Collection<Modification> modifications = this.getModifications();
            if (modifications != null && modifications.size() != 0) {
                int modificationNumber = 0;
                for (Modification modification : modifications) {
                    buffer.put(UniversalTag.SEQUENCE.getValue());
                    int localModificationSequenceLength = this.getChangeLength().get(modificationNumber);
                    buffer.put(TLV.getBytes(localModificationSequenceLength));
                    buffer.put(UniversalTag.ENUMERATED.getValue());
                    buffer.put((byte)1);
                    buffer.put((byte)modification.getOperation().getValue());
                    buffer.put(UniversalTag.SEQUENCE.getValue());
                    int localModificationLength = this.getModificationLength().get(modificationNumber);
                    buffer.put(TLV.getBytes(localModificationLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, modification.getAttribute().getUpId());
                    buffer.put(UniversalTag.SET.getValue());
                    int localValuesLength = this.getValuesLength().get(modificationNumber);
                    buffer.put(TLV.getBytes(localValuesLength));
                    if (modification.getAttribute().size() != 0) {
                        for (Value value : modification.getAttribute()) {
                            if (!value.isBinary()) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getString());
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getBytes());
                        }
                    }
                    ++modificationNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

