/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDnRequestDecorator
extends SingleReplyRequestDecorator<ModifyDnRequest, ModifyDnResponse>
implements ModifyDnRequest {
    private int modifyDnRequestLength;

    public ModifyDnRequestDecorator(LdapCodecService codec, ModifyDnRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setModifyDnRequestLength(int modifyDnRequestLength) {
        this.modifyDnRequestLength = modifyDnRequestLength;
    }

    public int getModifyDnResponseLength() {
        return this.modifyDnRequestLength;
    }

    @Override
    public Dn getName() {
        return ((ModifyDnRequest)this.getDecorated()).getName();
    }

    @Override
    public void setName(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
    }

    @Override
    public Rdn getNewRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getNewRdn();
    }

    @Override
    public void setNewRdn(Rdn newRdn) {
        ((ModifyDnRequest)this.getDecorated()).setNewRdn(newRdn);
    }

    @Override
    public boolean getDeleteOldRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    @Override
    public void setDeleteOldRdn(boolean deleteOldRdn) {
        ((ModifyDnRequest)this.getDecorated()).setDeleteOldRdn(deleteOldRdn);
    }

    @Override
    public Dn getNewSuperior() {
        return ((ModifyDnRequest)this.getDecorated()).getNewSuperior();
    }

    @Override
    public void setNewSuperior(Dn newSuperior) {
        ((ModifyDnRequest)this.getDecorated()).setNewSuperior(newSuperior);
    }

    @Override
    public boolean isMove() {
        return ((ModifyDnRequest)this.getDecorated()).isMove();
    }

    @Override
    public int computeLength() {
        int newRdnlength = Strings.getBytesUtf8(this.getNewRdn().getName()).length;
        int modifyDNRequestLength = 1 + TLV.getNbBytes(Dn.getNbBytes(this.getName())) + Dn.getNbBytes(this.getName()) + 1 + TLV.getNbBytes(newRdnlength) + newRdnlength + 1 + 1 + 1;
        if (this.getNewSuperior() != null) {
            modifyDNRequestLength += 1 + TLV.getNbBytes(Dn.getNbBytes(this.getNewSuperior())) + Dn.getNbBytes(this.getNewSuperior());
        }
        this.setModifyDnRequestLength(modifyDNRequestLength);
        return 1 + TLV.getNbBytes(modifyDNRequestLength) + modifyDNRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)108);
            buffer.put(TLV.getBytes(this.getModifyDnResponseLength()));
            Value.encode(buffer, Dn.getBytes(this.getName()));
            Value.encode(buffer, this.getNewRdn().getName());
            Value.encode(buffer, this.getDeleteOldRdn());
            if (this.getNewSuperior() != null) {
                buffer.put((byte)-128);
                int newSuperiorLength = Dn.getNbBytes(this.getNewSuperior());
                buffer.put(TLV.getBytes(newSuperiorLength));
                if (newSuperiorLength != 0) {
                    buffer.put(Dn.getBytes(this.getNewSuperior()));
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

