/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.name.Dn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteRequestDecorator
extends SingleReplyRequestDecorator<DeleteRequest, DeleteResponse>
implements DeleteRequest {
    public DeleteRequestDecorator(LdapCodecService codec, DeleteRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public Dn getName() {
        return ((DeleteRequest)this.getDecorated()).getName();
    }

    @Override
    public void setName(Dn name) {
        ((DeleteRequest)this.getDecorated()).setName(name);
    }

    @Override
    public int computeLength() {
        return 1 + TLV.getNbBytes(Dn.getNbBytes(this.getName())) + Dn.getNbBytes(this.getName());
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)74);
            buffer.put(TLV.getBytes(Dn.getNbBytes(this.getName())));
            buffer.put(Dn.getBytes(this.getName()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

