/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareRequestDecorator
extends SingleReplyRequestDecorator<CompareRequest, CompareResponse>
implements CompareRequest {
    private byte[] attrIdBytes;
    private byte[] attrValBytes;
    private int compareRequestLength;
    private int avaLength;

    public CompareRequestDecorator(LdapCodecService codec, CompareRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setCompareRequestLength(int compareRequestLength) {
        this.compareRequestLength = compareRequestLength;
    }

    public int getCompareRequestLength() {
        return this.compareRequestLength;
    }

    public void setAvaLength(int avaLength) {
        this.avaLength = avaLength;
    }

    public int getAvaLength() {
        return this.avaLength;
    }

    public byte[] getAttrIdBytes() {
        return this.attrIdBytes;
    }

    public void setAttrIdBytes(byte[] attrIdBytes) {
        this.attrIdBytes = attrIdBytes;
    }

    public byte[] getAttrValBytes() {
        return this.attrValBytes;
    }

    public void setAttrValBytes(byte[] attrValBytes) {
        this.attrValBytes = attrValBytes;
    }

    @Override
    public Dn getName() {
        return ((CompareRequest)this.getDecorated()).getName();
    }

    @Override
    public void setName(Dn name) {
        ((CompareRequest)this.getDecorated()).setName(name);
    }

    @Override
    public Value<?> getAssertionValue() {
        return ((CompareRequest)this.getDecorated()).getAssertionValue();
    }

    @Override
    public void setAssertionValue(String value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
    }

    @Override
    public void setAssertionValue(byte[] value) {
        ((CompareRequest)this.getDecorated()).setAssertionValue(value);
    }

    @Override
    public String getAttributeId() {
        return ((CompareRequest)this.getDecorated()).getAttributeId();
    }

    @Override
    public void setAttributeId(String attrId) {
        ((CompareRequest)this.getDecorated()).setAttributeId(attrId);
    }

    @Override
    public int computeLength() {
        Dn entry = this.getName();
        int compareRequestLength = 1 + TLV.getNbBytes(Dn.getNbBytes(entry)) + Dn.getNbBytes(entry);
        byte[] attributeIdBytes = Strings.getBytesUtf8(this.getAttributeId());
        int avaLength = 1 + TLV.getNbBytes(attributeIdBytes.length) + attributeIdBytes.length;
        this.setAttrIdBytes(attributeIdBytes);
        Value<?> assertionValue = this.getAssertionValue();
        if (assertionValue instanceof BinaryValue) {
            byte[] value = this.getAssertionValue().getBytes();
            avaLength += 1 + TLV.getNbBytes(value.length) + value.length;
            this.setAttrValBytes(value);
        } else {
            byte[] value = Strings.getBytesUtf8(this.getAssertionValue().getString());
            avaLength += 1 + TLV.getNbBytes(value.length) + value.length;
            this.setAttrValBytes(value);
        }
        this.setAvaLength(avaLength);
        this.setCompareRequestLength(compareRequestLength += 1 + TLV.getNbBytes(avaLength) + avaLength);
        return 1 + TLV.getNbBytes(compareRequestLength) + compareRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)110);
            buffer.put(TLV.getBytes(this.getCompareRequestLength()));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, Dn.getBytes(this.getName()));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes(this.getAvaLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, this.getAttrIdBytes());
        org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, this.getAttrValBytes());
        return buffer;
    }
}

