/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.shared.ldap.model.message.BindResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindResponseDecorator
extends ResponseDecorator<BindResponse>
implements BindResponse {
    private int bindResponseLength;

    public BindResponseDecorator(LdapCodecService codec, BindResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setBindResponseLength(int bindResponseLength) {
        this.bindResponseLength = bindResponseLength;
    }

    public int getBindResponseLength() {
        return this.bindResponseLength;
    }

    @Override
    public byte[] getServerSaslCreds() {
        return ((BindResponse)this.getDecorated()).getServerSaslCreds();
    }

    @Override
    public void setServerSaslCreds(byte[] serverSaslCreds) {
        ((BindResponse)this.getDecorated()).setServerSaslCreds(serverSaslCreds);
    }

    @Override
    public int computeLength() {
        int ldapResultLength;
        BindResponse bindResponse = (BindResponse)this.getDecorated();
        int bindResponseLength = ldapResultLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        byte[] serverSaslCreds = bindResponse.getServerSaslCreds();
        if (serverSaslCreds != null) {
            bindResponseLength += 1 + TLV.getNbBytes(serverSaslCreds.length) + serverSaslCreds.length;
        }
        this.setBindResponseLength(bindResponseLength);
        return 1 + TLV.getNbBytes(bindResponseLength) + bindResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        BindResponse bindResponse = (BindResponse)this.getDecorated();
        try {
            buffer.put((byte)97);
            buffer.put(TLV.getBytes(this.getBindResponseLength()));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
            byte[] serverSaslCreds = bindResponse.getServerSaslCreds();
            if (serverSaslCreds != null) {
                buffer.put((byte)-121);
                buffer.put(TLV.getBytes(serverSaslCreds.length));
                if (serverSaslCreds.length != 0) {
                    buffer.put(serverSaslCreds);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

