/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.RequestDecorator;
import org.apache.directory.shared.ldap.model.message.AbandonRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbandonRequestDecorator
extends RequestDecorator<AbandonRequest>
implements AbandonRequest {
    public AbandonRequestDecorator(LdapCodecService codec, AbandonRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public int getAbandoned() {
        return ((AbandonRequest)this.getDecorated()).getAbandoned();
    }

    @Override
    public void setAbandoned(int requestId) {
        ((AbandonRequest)this.getDecorated()).setAbandoned(requestId);
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)80);
            buffer.put((byte)Value.getNbBytes(this.getAbandoned()));
            buffer.put(Value.getBytes(this.getAbandoned()));
        }
        catch (BufferOverflowException boe) {
            String msg = I18n.err(I18n.ERR_04005, new Object[0]);
            throw new EncoderException(msg);
        }
        return buffer;
    }

    @Override
    public int computeLength() {
        int length = 2 + Value.getNbBytes(this.getAbandoned());
        return length;
    }
}

